package plus.ibatis.hbatis.orm.criteria;

import java.util.ArrayList;
import java.util.List;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
/**
 * Aggregations
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class Aggregations<E> extends EntityOpt<E>{
	
	private Aggregations(EntityNode<E> n) {
		super(n);
	}


	private List<Aggregation> aggregationList = new ArrayList<Aggregation>();
	
	public static <E> Aggregations<E> newInstance(EntityNode<E> n){
		return new Aggregations<>(n);
	}
	public Aggregations<E> count(FieldNode<E,?> fn) {
		aggregation(fn,"count");
		return this;
	}
	public Aggregations<E> count(FieldNode<E,?> fn,String alias) {
		aggregation(fn,"count",alias);
		return this;
	}
	public Aggregations<E> sum(FieldNode<E,?> fn) {
		aggregation(fn,"sum");
		return this;
	}
	public Aggregations<E> sum(FieldNode<E,?> fn,String alias) {
		aggregation(fn,"sum",alias);
		return this;
	}
	public Aggregations<E> min(FieldNode<E,?> fn) {
		aggregation(fn,"min");
		return this;
	}
	public Aggregations<E> min(FieldNode<E,?> fn,String alias) {
		aggregation(fn,"min",alias);
		return this;
	}
	public Aggregations<E> max(FieldNode<E,?> fn) {
		aggregation(fn,"max");
		return this;
	}
	public Aggregations<E> max(FieldNode<E,?> fn,String alias) {
		aggregation(fn,"max",alias);
		return this;
	}
	public Aggregations<E> avg(FieldNode<E,?> fn) {
		aggregation(fn,"avg");
		return this;
	}
	public Aggregations<E> avg(FieldNode<E,?> fn,String alias) {
		aggregation(fn,"avg",alias);
		return this;
	}
	private Aggregations<E> aggregation(FieldNode<E,?> fn,String op) {
		aggregationList.add(new Aggregation(fn,op,fn.getFieldMeta().getPropertyName()));
		return this;
	}
	private Aggregations<E> aggregation(FieldNode<E,?> fn,String op,String alias) {
		aggregationList.add(new Aggregation(fn,op,alias));
		return this;
	}
	
	
	public List<Aggregation> getAggregationList() {
		return aggregationList;
	}
	public int size() {
		return this.aggregationList.size();
	}
	public String toString() {
		List<Aggregations.Aggregation> list = this.getAggregationList();
		if( list == null || list.isEmpty()) return null;
		StringBuilder sb = new StringBuilder();
		for(Aggregations.Aggregation o:list){
			sb.append(",").append(o.getOp()).append("(");
			sb.append(o.getNode().getSqlColumn()).append(")").append(" ").append(o.getAlias());
		}
		return sb.substring(1);
	}


	public static class Aggregation {
		@SuppressWarnings("rawtypes")
		private FieldNode node;
		private String op;
		private String alias;
		public Aggregation(@SuppressWarnings("rawtypes") FieldNode node,String op,String alias){
			this.node = node;
			this.op = op;
			this.alias = alias;
		}
		
		@SuppressWarnings("rawtypes")
		public FieldNode getNode() {
			return node;
		}

		public String getOp() {
			return op;
		}

		public String getAlias() {
			return alias;
		}
		
	}
}
