package plus.ibatis.hbatis.orm.criteria;

import java.util.ArrayList;
import java.util.List;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.lambda.SFunction;
import plus.ibatis.hbatis.core.util.LambdaUtils;

/**
 * entity operation
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class EntityOpt<T> extends SqlSegment<T> {

	public EntityOpt(EntityNode<T> entityNode) {
		super(entityNode);
	}
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public List<FieldNode<T,?>> fields(String ...prop) {
		List<FieldNode<T,?>> rs = new ArrayList<>();
		for(String tmp:prop) {
			FieldNode fn = this.getEntityNode().getFieldNode(tmp);
			rs.add(fn);
		}
		return rs;
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public <K> FieldNode<T,K> field(String prop) {
		FieldNode fn = this.getEntityNode().getFieldNode(prop);
		return fn;
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public <K> FieldNode<T,K> field(SFunction<? super T,?> func) {
		String prop = prop(func);
		FieldNode fn = this.getEntityNode().getFieldNode(prop);
		return fn;
	}
	/**
	 * extract prop
	 * @param func 
	 * 			property extract function
	 * @return property name
	 */
	public String prop(SFunction<? super T,?> func) {
		return LambdaUtils.extractProperty(func);
	}
	
}
