package plus.ibatis.hbatis.orm.criteria;

import plus.ibatis.hbatis.core.meta.FieldMeta;

/**
 * field meta
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class FieldMetadata<E, T> {

	private FieldMeta<E, T> fieldMeta;
	
	/**
	 * 值表达式
	 */
	private String valueExpression;
	private T value;
	private FieldMeta<E,T> valueMeta;

	public FieldMeta<E, T> getFieldMeta() {
		return fieldMeta;
	}

	public void setFieldMeta(FieldMeta<E, T> field) {
		this.fieldMeta = field;
	}

	public T getValue() {
		return value;
	}

	public void setValue(T value) {
		this.value = value;
	}
	
	public FieldMeta<E, T> getValueMeta() {
		return valueMeta;
	}

	public void setValueMeta(FieldMeta<E, T> valueMeta) {
		this.valueMeta = valueMeta;
	}

	public FieldMetadata(){}
	public FieldMetadata(FieldMeta<E, T> field, T value) {
		this.fieldMeta = field;
		this.value = value;
	}
	public FieldMetadata(FieldMeta<E, T> field, FieldMeta<E,T> value) {
		this.fieldMeta = field;
		this.valueMeta = value;
	}

	public String getValueExpression() {
		return valueExpression;
	}

	public void setValueExpression(String valueExpression) {
		this.valueExpression = valueExpression;
	}
	
}
