package plus.ibatis.hbatis.orm.criteria;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;

/**
 * FieldMetadatas
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class FieldMetadatas<E> extends SqlSegment<E>{
	
	private FieldMetadatas(EntityNode<E> n) {
		super(n);
		this.fieldList = new ArrayList<>();
	}
	public static <E> FieldMetadatas<E> newInstance(EntityNode<E> n){
		return new FieldMetadatas<>(n);
	}
	private List<FieldMetadata<E,?>> fieldList ;
	
	public List<FieldMetadata<E,?>> getFieldMetadataList() {
		return fieldList;
	}

	public void setFieldMetadataList(List<FieldMetadata<E,?>> fieldList) {
		this.fieldList = fieldList;
	}
	public  <T> FieldMetadatas<E> setFieldValue(FieldNode<E,T> fieldNode,T val){
		FieldMetadata<E,T> uf = instanceField(fieldNode);
		uf.setValue(val);
		return this;
	}
	public <V> void setFieldNodeValue(FieldNode<E, V> fieldNode, FieldNode<E,V> valueNode) {
		FieldMetadata<E, V> uf = instanceField(fieldNode);
		if(valueNode != null) {
			uf.setValueMeta(valueNode.getFieldMeta());
		}
	}
	/**
	 * set field expression
	 * @param <V> EntityClass
	 * @param fieldNode
	 * 			field node
	 * @param expression
	 * 			such as column_count+1
	 */
	public <V> void setFieldExpressionValue(FieldNode<E, V> fieldNode,String expression) {
		FieldMetadata<E, V> uf = instanceField(fieldNode);
		uf.setValueExpression(expression);
	}
	
	@SuppressWarnings("unchecked")
	private <V> FieldMetadata<E, V> instanceField(FieldNode<E,V> fieldNode){
		for(FieldMetadata<E,?> f:this.fieldList) {
			if(f.getFieldMeta().equals(fieldNode.getFieldMeta())) {
				return (FieldMetadata<E, V>) f;
			}
		}
		FieldMetadata<E, V> uf = new FieldMetadata<E, V>();
		uf.setFieldMeta(fieldNode.getFieldMeta());
		this.fieldList.add(uf);
		return uf;
	}
	/**
	 * remove field
	 * @param <V> EntityClass
	 * @param fieldNode
	 * 			field node
	 */
	public <V> void removeField(FieldNode<E, V> fieldNode) {
		Iterator<FieldMetadata<E,?>> it = this.fieldList.iterator();
		while(it.hasNext()) {
			FieldMetadata<E,?> f = it.next();
			if(f.getFieldMeta().equals(fieldNode.getFieldMeta())) {
				it.remove();
				return ;
			}
		}
	}
	
}
