package plus.ibatis.hbatis.orm.criteria;

import java.util.ArrayList;
import java.util.List;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
/**
 * @see plus.ibatis.hbatis.orm.criteria.Aggregations
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class Havings<E> extends SqlSegment<E>{
	
	private Havings(EntityNode<E> n) {
		super(n);
	}


	private List<Having> havingList = new ArrayList<>();
	
	public static <E> Havings<E> newInstance(EntityNode<E> n){
		return new Havings<E>(n);
	}
	public Havings<E> count(FieldNode<E,?> fn,String criterionOp,Number criterionValue) {
		having(fn,"count",criterionOp,criterionValue);
		return this;
	}
	public Havings<E> sum(FieldNode<E,?> fn,String criterionOp,Number criterionValue) {
		having(fn,"sum",criterionOp,criterionValue);
		return this;
	}
	public Havings<E> min(FieldNode<E,?> fn,String criterionOp,Number criterionValue) {
		having(fn,"min",criterionOp,criterionValue);
		return this;
	}
	public Havings<E> max(FieldNode<E,?> fn,String criterionOp,Number criterionValue) {
		having(fn,"max",criterionOp,criterionValue);
		return this;
	}
	public Havings<E> avg(FieldNode<E,?> fn,String criterionOp,Number criterionValue) {
		having(fn,"avg",criterionOp,criterionValue);
		return this;
	}
	private Havings<E> having(FieldNode<E,?> node,String op,String criterionOp,Number criterionValue) {
		havingList.add(new Having(node,op,criterionOp,criterionValue));
		return this;
	}
	
	
	public List<Having> getHavingList() {
		return havingList;
	}
	public int size() {
		return this.havingList.size();
	}
	public String toString() {
		List<Havings.Having> list = this.getHavingList();
		if( list == null || list.isEmpty()) return null;
		StringBuilder sb = new StringBuilder();
		for(Havings.Having o:list){
			sb.append(",").append(o.getOp()).append("(");
			sb.append(o.getNode().getSqlColumn()).append(o.getCriterionOp()).append(o.getCriterionValue()).append(")");
		}
		return sb.substring(1);
	}


	public static class Having {
		@SuppressWarnings("rawtypes")
		private FieldNode node;
		private String op;
		
		private String criterionOp;
		private Number criterionValue;
		public Having(@SuppressWarnings("rawtypes") FieldNode node,String op,String criterionOp,Number criterionValue){
			this.node = node;
			this.op = op;
			this.criterionOp = criterionOp;
			this.criterionValue = criterionValue;
		}

		@SuppressWarnings("rawtypes")
		public FieldNode getNode() {
			return node;
		}



		public String getCriterionOp() {
			return criterionOp;
		}

		public Number getCriterionValue() {
			return criterionValue;
		}

		public String getOp() {
			return op;
		}
		
	}
}
