package plus.ibatis.hbatis.orm.criteria;

import java.util.ArrayList;
import java.util.List;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.lambda.SFunction;
/**
 * Orders
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class Orders<E> extends EntityOpt<E>{
	
	private Orders(EntityNode<E> n) {
		super(n);
	}


	private List<SortOrder> orderList = new ArrayList<SortOrder>();
	
	public static <E> Orders<E> newInstance(EntityNode<E> n){
		return new Orders<>(n);
	}
	/**
	 * desc
	 * @param fn
	 * 			field node
	 * @return Orders
	 */
	public Orders<E> desc(FieldNode<E,?> fn) {
		order(fn,"desc");
		return this;
	}
	/**
	 * asc
	 * @param fn
	 * 			field node
	 * @return Orders
	 */
	public Orders<E> asc(FieldNode<E,?> fn) {
		order(fn,"asc");
		return this;
	}
	private Orders<E> order(FieldNode<E,?> fn,String type) {
		orderList.add(new SortOrder(fn,type));
		return this;
	}
	
	public Orders<E> desc(SFunction<? super E,?> func) {
		String prop = prop(func);
		return desc(this.field(prop));
	}
	public Orders<E> asc(SFunction<? super E,?> func) {
		String prop = prop(func);
		return asc(this.field(prop));
	}

	public Orders<E> desc(String prop) {
		return desc(this.field(prop));
	}
	public Orders<E> asc(String prop) {
		return asc(this.field(prop));
	}
	
	public List<SortOrder> getOrderList() {
		return orderList;
	}
	public int size() {
		return this.orderList.size();
	}
	public void reset() {
		this.orderList.clear();
	}
	public String toString() {
		List<SortOrder> list = this.getOrderList();
		if( list == null || list.isEmpty()) return null;
		StringBuilder sb = new StringBuilder();
		for(SortOrder o:list){
			sb.append(",");
			sb.append(o.getSortField().getSqlColumn()).append(" ").append(o.getSortType());
		}
		return sb.substring(1);
	}
	public static <E> Orders<E> fromString(EntityNode<E> entityNode,String orderBys) {
		if(orderBys == null || orderBys.trim().equals("")) {
			return null;
		}
		Orders<E> sortOrders = new Orders<>(entityNode);
		String[] orderByArr = orderBys.split(",");
		
		for(String orderBy:orderByArr) {
			String[] tmpArr = orderBy.split("(\\||\\s+)");
			String sortType = tmpArr[1];
			String sortField = tmpArr[0];
			List<FieldNode<E,?>> nodes = entityNode.getFieldNodes();
			for(FieldNode<E,?> tmp:nodes) {
				if(tmp.getFieldMeta().getPropertyName().equals(sortField)) {
					sortOrders.order(tmp, sortType.equals("desc")?"desc":"asc");
					break;
				}
			}
		}
		return sortOrders;
	}
}
