package plus.ibatis.hbatis.orm.criteria.opt;

import java.util.ArrayList;
import java.util.List;

import plus.ibatis.hbatis.core.Criterion;
import plus.ibatis.hbatis.core.CriterionOpts;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.lambda.SFunction;
import plus.ibatis.hbatis.orm.criteria.EntityOpt;
/**
 * DefaultCriteriaOpt
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class DefaultCriteriaOpt<T> extends EntityOpt<T> implements ICriteriaOpt<T> {
	
	private List<Criterion<T,?>> criterions;
	public DefaultCriteriaOpt(EntityNode<T> entityNode) {
		super(entityNode);
		this.criterions = new ArrayList<>();
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> eq(FieldNode fn, Object value) {
		this.criterions.add(fn.eq(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> ne(FieldNode fn, Object value) {
		this.criterions.add(fn.ne(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> in(FieldNode fn, List value) {
		this.criterions.add(fn.in(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> notIn(FieldNode fn, List value) {
		this.criterions.add(fn.notIn(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> like(FieldNode fn, String value) {
		this.criterions.add(fn.like(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> notLike(FieldNode fn, String value) {
		this.criterions.add(fn.notLike(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> between(FieldNode fn,Object value1,Object value2) {
		this.criterions.add(fn.between(value1,value2));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> notBetween(FieldNode fn, Object value1,Object value2) {
		this.criterions.add(fn.notBetween(value1,value2));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> isNotNull(FieldNode fn,String prop) {
		this.criterions.add(fn.isNotNull());
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> isNull(FieldNode fn) {
		this.criterions.add(fn.isNull());
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> lt(FieldNode fn,Object value) {
		this.criterions.add(fn.lt(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> gt(FieldNode fn,Object value) {
		this.criterions.add(fn.gt(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> le(FieldNode fn,Object value) {
		this.criterions.add(fn.le(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> ge(FieldNode fn,Object value) {
		this.criterions.add(fn.ge(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> sql(FieldNode fn,CriterionOpts opt,String value) {
		this.criterions.add(fn.sql(opt, value));
		return this;
	}
	
	
	
	// -- prop
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> eq(String prop, Object value) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.eq(value));
		
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> ne(String prop, Object value) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.ne(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> in(String prop, List value) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.in(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> notIn(String prop, List value) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.notIn(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> like(String prop, String value) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.like(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> notLike(String prop, String value) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.notLike(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> between(String prop, Object value1,Object value2) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.between(value1,value2));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> notBetween(String prop, Object value1,Object value2) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.notBetween(value1,value2));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> isNotNull(String prop) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.isNotNull());
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> isNull(String prop) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.isNull());
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> lt(String prop,Object value) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.lt(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> gt(String prop,Object value) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.gt(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> le(String prop,Object value) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.le(value));
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> ge(String prop,Object value) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.ge(value));
		return this;
	}
	// --- lambda

	public ICriteriaOpt<T> eq(SFunction<? super T,?> func, Object value) {
		this.eq(prop(func), value);
		return this;
	}
	public ICriteriaOpt<T> ne(SFunction<? super T,?> func, Object value) {
		this.ne(prop(func),value);
		return this;
	}
	
	public <V> ICriteriaOpt<T> in(SFunction<? super T,?> func, List<V> value) {
		this.in(prop(func),value);
		return this;
	}
	
	public <V> ICriteriaOpt<T> notIn(SFunction<? super T,?> func,List<V> value) {
		this.notIn(prop(func),value);
		return this;
	}
	public ICriteriaOpt<T> like(SFunction<? super T,?> func, String value) {
		this.like(prop(func),value);
		return this;
	}
	public ICriteriaOpt<T> notLike(SFunction<? super T,?> func, String value) {
		this.notLike(prop(func),value);
		return this;
	}
	public ICriteriaOpt<T> between(SFunction<? super T,?> func, Object value1,Object value2) {
		this.between(prop(func),value1,value2);
		return this;
	}
	public ICriteriaOpt<T> notBetween(SFunction<? super T,?> func, Object value1,Object value2) {
		this.notBetween(prop(func),value1,value2);
		return this;
	}
	public ICriteriaOpt<T> isNotNull(SFunction<? super T,?> func) {
		this.isNotNull(prop(func));
		return this;
	}
	public ICriteriaOpt<T> isNull(SFunction<? super T,?> func) {
		this.isNull(prop(func));
		return this;
	}
	public ICriteriaOpt<T> lt(SFunction<? super T,?> func,Object value) {
		this.lt(prop(func), value);
		return this;
	}
	public ICriteriaOpt<T> gt(SFunction<? super T,?> func,Object value) {
		this.gt(prop(func), value);
		return this;
	}
	public  ICriteriaOpt<T> le(SFunction<? super T,?> func,Object value) {
		this.le(prop(func), value);
		return this;
	}
	
	public ICriteriaOpt<T> ge(SFunction<? super T,?> func,Object value) {
		this.ge(prop(func), value);
		return this;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ICriteriaOpt<T> sql(String prop,CriterionOpts opt,String value) {
		FieldNode fn = field(prop);
		this.criterions.add(fn.sql(opt, value));
		return this;
	}
	
	public ICriteriaOpt<T> sql(SFunction<? super T,?> func,CriterionOpts opt,String value) {
		this.sql(prop(func), opt, value);
		return this;
	}
	public List<Criterion<T,?>> getCriterions() {
		return this.criterions;
	}
	

}
