package plus.ibatis.hbatis.orm.criteria.opt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.lambda.SFunction;
import plus.ibatis.hbatis.orm.criteria.EntityOpt;
import plus.ibatis.hbatis.orm.criteria.FieldMetadata;

/**
 * DefaultFieldValueOpt
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class DefaultFieldValueOpt<T> extends EntityOpt<T> implements IFieldValueOpt<T> {

	private List<FieldMetadata<T,?>> fields ;
	
	public DefaultFieldValueOpt(EntityNode<T> entityNode) {
		super(entityNode);
		this.fields = new ArrayList<>();
	}
	/**
	 * set field value
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public DefaultFieldValueOpt<T> setField(String field, Object val) {
		FieldNode fn = field(field);
		FieldMetadata m = new FieldMetadata(fn.getFieldMeta(),val);
		this.fields.add(m);
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public DefaultFieldValueOpt<T> setField(FieldNode fn, Object val) {
		FieldMetadata m = new FieldMetadata(fn.getFieldMeta(),val);
		this.fields.add(m);
		return this;
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public DefaultFieldValueOpt<T> setFieldNodeValue(String field, String field2) {
		FieldNode fn = field(field);
		FieldNode fn2 = field(field2);
		FieldMetadata m = new FieldMetadata();
		m.setFieldMeta(fn.getFieldMeta());
		m.setValueMeta(fn2.getFieldMeta());
		this.fields.add(m);
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public DefaultFieldValueOpt<T> setFieldNodeValue(FieldNode fn, FieldNode val) {
		FieldMetadata m = new FieldMetadata();
		m.setFieldMeta(fn.getFieldMeta());
		m.setValueMeta(val.getFieldMeta());
		this.fields.add(m);
		return this;
	}
	/**
	 * set field expression
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public DefaultFieldValueOpt<T> setFieldExpression(String field, String expression) {
		FieldNode fn = field(field);
		FieldMetadata m = new FieldMetadata();
		m.setFieldMeta(fn.getFieldMeta());
		m.setValueExpression(expression);
		this.fields.add(m);
		return this;
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public DefaultFieldValueOpt<T> setFieldExpression(FieldNode fn, String expression) {
		FieldMetadata m = new FieldMetadata();
		m.setFieldMeta(fn.getFieldMeta());
		m.setValueExpression(expression);
		this.fields.add(m);
		return this;
	}
	
	// --- lambda
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public DefaultFieldValueOpt<T> setField(SFunction<? super T,?> fieldFunc,Object value) {
		String prop = prop(fieldFunc);
		FieldNode<T,?> fn = field(prop);
		FieldMetadata m = new FieldMetadata(fn.getFieldMeta(),value);
		this.fields.add(m);
		return this;
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public DefaultFieldValueOpt<T> setFieldExpression(SFunction<? super T,?> fieldFunc,String express) {
		String prop = prop(fieldFunc);
		FieldNode<T,?> fn = field(prop);
		FieldMetadata m = new FieldMetadata();
		m.setFieldMeta(fn.getFieldMeta());
		m.setValueExpression(express);
		this.fields.add(m);
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public DefaultFieldValueOpt<T> setFieldNodeValue(SFunction<? super T,?> fieldFunc,SFunction<? super T,?> valueFunc) {
		String prop = prop(fieldFunc);
		String value = prop(valueFunc);
		FieldNode<T,?> fieldNode = field(prop);
		FieldNode<T,?> valueNode = field(value);
		FieldMetadata m = new FieldMetadata(fieldNode.getFieldMeta(),valueNode.getFieldMeta());
		this.fields.add(m);
		return this;
	}
	/**
	 * set field null
	 */
	public DefaultFieldValueOpt<T> removeField(FieldNode<T, ?> fieldNode) {
		Iterator<FieldMetadata<T,?>> it = this.fields.iterator();
		while(it.hasNext()) {
			FieldMetadata<T,?> f = it.next();
			if(f.getFieldMeta().equals(fieldNode.getFieldMeta())) {
				it.remove();
				return this;
			}
		}
		return this;
	}
	public List<FieldMetadata<T, ?>> getFields() {
		return fields;
	}
	
	
}
