package plus.ibatis.hbatis.orm.criteria.opt;

import java.util.List;

import plus.ibatis.hbatis.core.Criterion;
import plus.ibatis.hbatis.core.CriterionOpts;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.lambda.SFunction;

public interface ICriteriaOpt<T> {
	/**
	 * = 
	 * @param <V> EntityClass
	 * @param fn fieldNode
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> eq(FieldNode<T, V> fn, V value);

	/**
	 * !=
	  * @param <V> EntityClass
	 * @param fn fieldNode
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> ne(FieldNode<T, V> fn, V value);

	/**
	 * in
	 * @param <V> EntityClass
	 * @param fn fieldNode
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> in(FieldNode<T, V> fn, List<V> value);

	/**
	 * not in
	  * @param <V> EntityClass
	 * @param fn fieldNode
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> notIn(FieldNode<T, V> fn, List<V> value);

	/**
	 * like
	 * @param fn fieldnode
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> like(FieldNode<T, String> fn, String value);

	/**
	 * not like
	 * @param fn fieldnode
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> notLike(FieldNode<T, String> fn, String value);

	/**
	 * between
	 * @param <V> propery class
	 * @param fn fieldnode
	 * @param value1 value1
	 * @param value2 value2
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> between(FieldNode<T, V> fn, V value1, V value2);

	/**
	 * not between
	 * @param <V> property class
	 * @param fn fieldnode
	 * @param value1 value1
	 * @param value2 value2
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> notBetween(FieldNode<T, V> fn, V value1, V value2);

	/**
	 * is not null
	 * @param <V> property class
	 * @param fn fieldnode
	 * @param prop property name
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> isNotNull(FieldNode<T, V> fn, String prop);

	/**
	 * is null
	 * @param <V> property class
	 * @param fn fieldnode
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> isNull(FieldNode<T, V> fn);

	/**
	 * less than
	* @param <V> property class
	 * @param fn fieldnode
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> lt(FieldNode<T, V> fn, V value);

	/**
	 * greater than
	* @param <V> property class
	 * @param fn fieldnode
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> gt(FieldNode<T, V> fn, V value);

	/**
	 * less than or equal
	 * @param <V> property class
	 * @param fn fieldnode
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> le(FieldNode<T, V> fn, V value);

	/**
	 * greater than or equal
	 * @param <V> property class
	 * @param fn fieldnode
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> ge(FieldNode<T, V> fn, V value);

	/**
	 * SQL
	 * 
	 * @param <V> property class
	 * @param fn fieldnode
	 * @param opt operation
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> sql(FieldNode<T, V> fn, CriterionOpts opt, String value);

	// -- prop
	/**
	 * =
	 * 
	 * @param prop property name
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> eq(String prop, Object value);

	/**
	 * !=
	 * 
	 * @param prop property name
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> ne(String prop, Object value);

	/**
	 * in
	 * @param <V> Value Type
	 * @param prop property name
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> in(String prop, List<V> value);

	/**
	 * not in
	 * @param <V> Value Type
	 * @param prop property name
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public <V> ICriteriaOpt<T> notIn(String prop, List<V> value);

	/**
	 * like
	 * 
	 * @param prop property name
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> like(String prop, String value);

	/**
	 * not like
	 * 
	 * @param prop property name
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> notLike(String prop, String value);

	/**
	 * between
	 * 
	 * @param prop property name
	 * @param value1 value1
	 * @param value2 value2
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> between(String prop, Object value1, Object value2);

	/**
	 * not between
	 * 
	 * @param prop property name
	 * @param value1 value1
	 * @param value2 value2
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> notBetween(String prop, Object value1, Object value2);

	/**
	 * is not null
	 * 
	 * @param prop property name
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> isNotNull(String prop);

	/**
	 * is null
	 * 
	 * @param prop property name
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> isNull(String prop);

	/**
	 * less than
	 * 
	 * @param prop property name
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> lt(String prop, Object value);

	/**
	 * greater than
	 * 
	 * @param prop property name
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> gt(String prop, Object value);

	/**
	 * less than or equal
	 * 
	 * @param prop property name
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> le(String prop, Object value);

	/**
	 * greater than or equal
	 * 
	 * @param prop property name
	 * @param value value
	 * @return ICriteriaOpt
	 */
	public ICriteriaOpt<T> ge(String prop, Object value);
	// --- lambda

	public ICriteriaOpt<T> eq(SFunction<? super T, ?> func, Object value);

	public ICriteriaOpt<T> ne(SFunction<? super T, ?> func, Object value);

	public <V> ICriteriaOpt<T> in(SFunction<? super T, ?> func, List<V> value);

	public <V> ICriteriaOpt<T> notIn(SFunction<? super T, ?> func, List<V> value);

	public ICriteriaOpt<T> like(SFunction<? super T, ?> func, String value);

	public ICriteriaOpt<T> notLike(SFunction<? super T, ?> func, String value);

	public ICriteriaOpt<T> between(SFunction<? super T, ?> func, Object value1, Object value2);

	public ICriteriaOpt<T> notBetween(SFunction<? super T, ?> func, Object value1, Object value2);

	public ICriteriaOpt<T> isNotNull(SFunction<? super T, ?> func);

	public ICriteriaOpt<T> isNull(SFunction<? super T, ?> func);

	public ICriteriaOpt<T> lt(SFunction<? super T, ?> func, Object value);

	public ICriteriaOpt<T> gt(SFunction<? super T, ?> func, Object value);

	public ICriteriaOpt<T> le(SFunction<? super T, ?> func, Object value);

	public ICriteriaOpt<T> ge(SFunction<? super T, ?> func, Object value);

	public ICriteriaOpt<T> sql(String prop, CriterionOpts opt, String value);

	public ICriteriaOpt<T> sql(SFunction<? super T, ?> func, CriterionOpts opt, String value);

	public List<Criterion<T, ? extends Object>> getCriterions();

}
