package plus.ibatis.hbatis.orm.criteria.opt;

import java.util.List;

import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.lambda.SFunction;
import plus.ibatis.hbatis.orm.criteria.FieldMetadata;

/**
 * field value operation
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public interface IFieldValueOpt<T>  {

	
	/**
	 * set field value
	 * @param field
	 * 			field property
	 * @param val
	 * 			field value
	 * @return IFieldValueOpt
	 */
	public IFieldValueOpt<T> setField(String field, Object val);
	public <K> IFieldValueOpt<T> setField(FieldNode<T,K> fn, Object val);
	public IFieldValueOpt<T> setFieldNodeValue(String field, String field2);
	public IFieldValueOpt<T> setFieldNodeValue(FieldNode<T,?> fn, FieldNode<T,?> val);
	/**
	 * set field expression
	 * @param field
	 * 			field property
	 * @param expression
	 * 			value expression
	 * @return IFieldValueOpt
	 */
	public IFieldValueOpt<T> setFieldExpression(String field, String expression);
	public IFieldValueOpt<T> setFieldExpression(FieldNode<T,?> fn, String expression);
	// --- lambda

	public IFieldValueOpt<T> setField(SFunction<? super T,?> fieldFunc,Object value);
	
	public IFieldValueOpt<T> setFieldExpression(SFunction<? super T,?> fieldFunc,String express);
	
	public IFieldValueOpt<T> setFieldNodeValue(SFunction<? super T,?> fieldFunc,SFunction<? super T,?> valueFunc);
	/**
	 * remove field value
	 * @param fieldNode fieldnode
	 * @return IFieldValueOpt
	 */
	public IFieldValueOpt<T> removeField(FieldNode<T, ?> fieldNode);
	public List<FieldMetadata<T, ?>> getFields();
	
	
}
