package plus.ibatis.hbatis.orm.criteria.statement;

import java.util.ArrayList;
import java.util.List;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.orm.criteria.Aggregations;
import plus.ibatis.hbatis.orm.criteria.Havings;
import plus.ibatis.hbatis.orm.criteria.Orders;
import plus.ibatis.hbatis.orm.criteria.PageRange;
import plus.ibatis.hbatis.orm.criteria.Restrictions;
import plus.ibatis.hbatis.orm.criteria.SqlSegment;
/**
 * AggregationStatement
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class AggregationStatement<E> extends SqlSegment<E> {
	
	
	private List<FieldNode<E,?>> groupBys = new ArrayList<>();
	
	private Havings<E> havings;
	/**
	 * 排序
	 */
	private Orders<E> orders;
	
	private Aggregations<E> aggregations;
	/**
	 * 约束
	 */
	private Restrictions<E> restrictions;
	
	
	private PageRange pageRange;
	
	private AggregationStatement(EntityNode<E> n){
		super(n);
		restrictions = Restrictions.newInstance(n);
	}
	public static <E> AggregationStatement<E> newInstance(EntityNode<E> n){
		return new AggregationStatement<>(n);
	}
	public Orders<E> orderby() {
		if(orders == null){
			orders = Orders.newInstance(this.getEntityNode());
		}
		return orders;
	}
	public Aggregations<E> aggregation() {
		if(aggregations == null){
			aggregations = Aggregations.newInstance(this.getEntityNode());
		}
		return aggregations;
	}
	public Havings<E> having() {
		if(havings == null){
			havings = Havings.newInstance(this.getEntityNode());
		}
		return havings;
	}
	public AggregationStatement<E> setPageRange(int start,int limit) {
		this.pageRange = new PageRange(start,limit);
		return this;
	}
	public Restrictions<E> restrictions(){
		return this.restrictions;
	}
	
	public Restrictions<E> getRestrictions() {
		return restrictions;
	}
	public void setRestrictions(Restrictions<E> restrictions) {
		this.restrictions = restrictions;
	}
	@SuppressWarnings("unchecked")
	public AggregationStatement<E> groupBy(FieldNode<E,?> ...fieldMore) {
		if(fieldMore.length>0) {
			for(FieldNode<E,?> f:fieldMore) {
				this.groupBys.add(f);
			}
		}
		return this;
	}
	
	public List<FieldNode<E, ?>> getGroupBys() {
		return groupBys;
	}
	public Orders<E> getOrders() {
		return orders;
	}
	public PageRange getPageRange() {
		return pageRange;
	}
	public void setPageRange(PageRange pageRange) {
		this.pageRange = pageRange;
	}
	public Havings<E> getHavings() {
		return havings;
	}
	public Aggregations<E> getAggregations() {
		return aggregations;
	}
	
	
	
}
