package plus.ibatis.hbatis.orm.criteria.statement;

import java.util.List;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.orm.criteria.FieldMetadata;
import plus.ibatis.hbatis.orm.criteria.FieldMetadatas;
import plus.ibatis.hbatis.orm.criteria.Restrictions;
import plus.ibatis.hbatis.orm.criteria.SqlSegment;
/**
 * InsertStatement
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class InsertStatement<E> extends SqlSegment<E> {
	
	private FieldMetadatas<E> fields;
	private InsertStatement(EntityNode<E> entityNode) {
		super(entityNode);
		fields = FieldMetadatas.newInstance(entityNode);
		this.restrictions = Restrictions.newInstance(entityNode);
	}
	public FieldMetadatas<E> fields(){
		return this.fields;
	}
	public FieldMetadatas<E> fields(List<FieldMetadata<E,?>> metas){
		fields.setFieldMetadataList(metas);
		return this.fields;
	}
	private Restrictions<E> restrictions;
	public Restrictions<E> getRestrictions() {
		return restrictions;
	}

	public Restrictions<E> restrictions() {
		return restrictions;
	}
	public List<FieldMetadata<E,?>> getFieldMetadataList() {
		return fields.getFieldMetadataList();
	}
	
	public static <E> InsertStatement<E> newInstance(EntityNode<E> entityNode){
		return new InsertStatement<>(entityNode);
	}
}
