package plus.ibatis.hbatis.orm.criteria.statement;

import java.util.List;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.orm.criteria.Orders;
import plus.ibatis.hbatis.orm.criteria.PageRange;
import plus.ibatis.hbatis.orm.criteria.Restrictions;
import plus.ibatis.hbatis.orm.criteria.SqlSegment;
/**
 * SelectStatement
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class SelectStatement<E> extends SqlSegment<E> {
	
	
	private List<FieldNode<E,?>> fields;
	/**
	 * 排序
	 */
	private Orders<E> orders;
	
	/**
	 * 约束
	 */
	private Restrictions<E> restrictions;
	
	
	private PageRange pageRange;
	
	private SelectStatement(EntityNode<E> n){
		super(n);
		restrictions = Restrictions.newInstance(n);
	}
	public static <E> SelectStatement<E> newInstance(EntityNode<E> n){
		return new SelectStatement<>(n);
	}
	public Orders<E> orderby() {
		if(orders == null){
			orders = Orders.newInstance(this.getEntityNode());
		}
		return orders;
	}
	public Orders<E> orderby(Orders<E> orders) {
		this.orders = orders;
		return orders;
	}
	public SelectStatement<E> setPageRange(int start,int limit) {
		this.pageRange = new PageRange(start,limit);
		return this;
	}
	public Restrictions<E> restrictions(){
		return this.restrictions;
	}
	
	public Restrictions<E> getRestrictions() {
		return restrictions;
	}
	public void setRestrictions(Restrictions<E> restrictions) {
		this.restrictions = restrictions;
	}
	public void setFields(List<FieldNode<E,?>> fields) {
		this.fields = fields;
	}
	
	public List<FieldNode<E, ?>> getFields() {
		return fields;
	}
	public Orders<E> getOrders() {
		return orders;
	}
	public PageRange getPageRange() {
		return pageRange;
	}
	public void setPageRange(PageRange pageRange) {
		this.pageRange = pageRange;
	}
	public Restrictions<E> newRestrictions() {
		return Restrictions.newInstance(this.getEntityNode());
	}
	
}
