package plus.ibatis.hbatis.orm.criteria.statement;

import java.util.List;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.orm.criteria.FieldMetadata;
import plus.ibatis.hbatis.orm.criteria.FieldMetadatas;
import plus.ibatis.hbatis.orm.criteria.Restrictions;
import plus.ibatis.hbatis.orm.criteria.SqlSegment;

/**
 * UpdateStatement
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class UpdateStatement<E> extends SqlSegment<E> {

	protected UpdateStatement(EntityNode<E> n) {
		super(n);
		fields = FieldMetadatas.newInstance(n);
		this.restrictions = Restrictions.newInstance(n);
	}

	public static <T> UpdateStatement<T> newInstance(EntityNode<T> entityNode) {
		return new UpdateStatement<>(entityNode);
	}
	private FieldMetadatas<E> fields;
	private Restrictions<E> restrictions;
	
	private int limit = -1;

	
	public Restrictions<E> getRestrictions() {
		return restrictions;
	}

	public Restrictions<E> restrictions() {
		return restrictions;
	}
	public FieldMetadatas<E> fields(){
		return this.fields;
	}
	public List<FieldMetadata<E,?>> getFieldMetadataList() {
		return fields.getFieldMetadataList();
	}
	public void setRestrictions(Restrictions<E> restrictions) {
		this.restrictions = restrictions;
	}
	public void setLimit(int limit) {
		this.limit = limit;
	}
	
	public int getLimit() {
		return limit;
	}

	public void fields(List<FieldMetadata<E, ?>> metas) {
		this.fields.setFieldMetadataList(metas);
	}
}
