package plus.ibatis.hbatis.orm.criteria.support;

import java.util.function.Consumer;

import plus.ibatis.hbatis.core.Criterion;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.orm.criteria.EntityOpt;
import plus.ibatis.hbatis.orm.criteria.Restrictions;
import plus.ibatis.hbatis.orm.criteria.opt.ICriteriaOpt;

public abstract class AbstractEntityQuery<T> extends EntityOpt<T> {
	
	protected AbstractEntityQuery(EntityNode<T> node) {
		super(node);
	}

	public abstract Restrictions<T> getRestrictions();
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Restrictions<T> where(Criterion ...criterion) {
		Restrictions<T> rs = this.getRestrictions();
		rs.and(criterion);
		return rs;
	}
	public Restrictions<T> where() {
		Restrictions<T> rs = this.getRestrictions();
		return rs;
	}
	public Restrictions<T> where(Consumer<ICriteriaOpt<T>> c) {
		return this.where().and(c);
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public AbstractEntityQuery<T> and(Criterion ...criterion) {
		
		this.where().and(criterion);
		return this;
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Restrictions<T> or(Criterion ...criterion) {
		this.where().or(criterion);
		return this.getRestrictions();
	}
}
