package plus.ibatis.hbatis.orm.criteria.support;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.lambda.SFunction;
import plus.ibatis.hbatis.orm.criteria.Orders;

public abstract class AbstractOrderedEntityQuery<T> extends AbstractEntityQuery<T> {
	public AbstractOrderedEntityQuery(EntityNode<T> node) {
		super(node);
	}

	public abstract Orders<T> getOrders();
	
	public AbstractOrderedEntityQuery<T> orderAsc(FieldNode<T, ?> field) {
		this.getOrders().asc(field);
		return this;
	}

	public AbstractOrderedEntityQuery<T> orderDesc(FieldNode<T, ?> field) {
		this.getOrders().desc(field);
		return this;
	}
	public AbstractOrderedEntityQuery<T> orderDesc(SFunction<? super T,?> func) {
		String prop = prop(func);
		return orderDesc(prop);
	}
	public AbstractOrderedEntityQuery<T> orderAsc(SFunction<? super T,?> func) {
		String prop = prop(func);
		return orderAsc(prop);
	}
	
	public AbstractOrderedEntityQuery<T> orderDesc(String prop) {
		FieldNode<T,?> fn = field(prop);
		return orderDesc(fn);
	}
	public AbstractOrderedEntityQuery<T> orderAsc(String prop) {
		FieldNode<T,?> fn = field(prop);
		return orderAsc(fn);
	}
}
