package plus.ibatis.hbatis.orm.criteria.support;

import java.util.List;
import java.util.Map;

import org.springframework.util.Assert;

import plus.ibatis.hbatis.core.AbstractEntityNode;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.orm.criteria.Aggregations;
import plus.ibatis.hbatis.orm.criteria.Havings;
import plus.ibatis.hbatis.orm.criteria.Orders;
import plus.ibatis.hbatis.orm.criteria.Restrictions;
import plus.ibatis.hbatis.orm.criteria.statement.AggregationStatement;
import plus.ibatis.hbatis.orm.mapper.HbatisStatementMapper;

/**
 * AggregationQuery
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class AggregationQuery<T> extends AbstractOrderedEntityQuery<T> {
	private HbatisStatementMapper<T> mapper;

	AggregationStatement<T> st;

	public AggregationQuery(HbatisStatementMapper<T> mapper, EntityNode<T> n) {
		super(n);
		this.mapper = mapper;
		this.st = AggregationStatement.newInstance(n);
	}
	public AggregationQuery<T> limit(int limit) {
		this.st.setPageRange(0,limit);
		return this;
	}
	public AggregationQuery<T> limit(int start, int limit) {
		this.st.setPageRange(start, limit);
		return this;
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public AggregationQuery<T> groupBy(FieldNode ...field) {
		this.st.groupBy(field);
		return this;
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public AggregationQuery<T> groupBy(List<FieldNode> fields) {
		for(FieldNode fn:fields) {
			this.st.groupBy(fn);
		}
		return this;
	}
	public Aggregations<T> aggregation(){
		return this.st.aggregation();
	}
	public Havings<T> having(){
		return this.st.having();
	}
	
	@SuppressWarnings("rawtypes")
	public List<Map> fetch(){
		return this.mapper.aggregate(this.st);
	}
	
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static <T> AggregationQuery<T> create(HbatisStatementMapper<T> repo, EntityNode<T> n) {
		return new AggregationQuery(repo, n);
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static <T> AggregationQuery<T> create(HbatisStatementMapper<T> repo, Class<T> clazz) {
		return new AggregationQuery(repo, AbstractEntityNode.of(clazz));
	}

	@Override
	public Restrictions<T> getRestrictions() {
		return this.st.restrictions();
	}

	@Override
	public Orders<T> getOrders() {
		return this.st.getOrders();
	}
	/**
	 * set next page params
	 */
	public void nextPage() {
		Assert.notNull(this.st.getPageRange(),"Page params not setted");
		Assert.isTrue(this.st.getPageRange().getLimit() > 0,"Limit of page params should greater then 0");
		this.st.getPageRange().setStart(this.st.getPageRange().getStart() + this.st.getPageRange().getLimit());
	}
}
