package plus.ibatis.hbatis.orm.criteria.support;

import plus.ibatis.hbatis.core.AbstractEntityNode;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.orm.criteria.Restrictions;
import plus.ibatis.hbatis.orm.mapper.HbatisStatementMapper;

/**
 * EntityDelete
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class EntityDelete<T> extends AbstractEntityQuery<T> {

	private HbatisStatementMapper<T> mapper;

	Restrictions<T> rs;
	public EntityDelete(HbatisStatementMapper<T> mapper, EntityNode<T> n) {
		super(n);
		this.mapper = mapper;
		this.rs = StatementBuilder.buildRestrictions(n);
	}
	public int execute() {
		return this.mapper.deleteByRestrictions(this.getRestrictions());
	}

	public Restrictions<T> getRestrictions() {
		return rs;
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static <T> EntityDelete<T> create(HbatisStatementMapper<T> repo, EntityNode<T> n) {
		return new EntityDelete(repo, n);
	}
	public static <T> EntityDelete<T> create(HbatisStatementMapper<T> repo, Class<T> clazz) {
		return create(repo,AbstractEntityNode.of(clazz));
	}
}
