package plus.ibatis.hbatis.orm.criteria.support;

import plus.ibatis.hbatis.core.AbstractEntityNode;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.orm.criteria.opt.DefaultFieldValueOpt;
import plus.ibatis.hbatis.orm.criteria.opt.IFieldValueOpt;
import plus.ibatis.hbatis.orm.criteria.statement.InsertStatement;
import plus.ibatis.hbatis.orm.mapper.HbatisStatementMapper;

/**
 * EntityInsert
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class EntityInsert<T> extends DefaultFieldValueOpt<T> implements IFieldValueOpt<T> {

	private HbatisStatementMapper<T> mapper;

	InsertStatement<T> st;
	
	public EntityInsert(HbatisStatementMapper<T> mapper, EntityNode<T> n) {
		super(n);
		this.mapper = mapper;
		this.st = StatementBuilder.buildInsert(n);
	}
	public int execute() {
		this.st.fields(this.getFields());
		return this.mapper.insertByStatement(st);
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static <T> EntityInsert<T> create(HbatisStatementMapper<T> repo, EntityNode<T> n) {
		return new EntityInsert(repo, n);
	}
	public static <T> EntityInsert<T> create(HbatisStatementMapper<T> repo,Class<T> clazz){
		return create(repo,AbstractEntityNode.of(clazz));
	}
}
