package plus.ibatis.hbatis.orm.criteria.support;

import java.util.List;

import plus.ibatis.hbatis.core.AbstractEntityNode;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.lambda.SFunction;
import plus.ibatis.hbatis.orm.criteria.FieldMetadata;
import plus.ibatis.hbatis.orm.criteria.Restrictions;
import plus.ibatis.hbatis.orm.criteria.opt.DefaultFieldValueOpt;
import plus.ibatis.hbatis.orm.criteria.opt.IFieldValueOpt;
import plus.ibatis.hbatis.orm.criteria.statement.UpdateStatement;
import plus.ibatis.hbatis.orm.mapper.HbatisStatementMapper;

/**
 * EntityUpdate
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class EntityUpdate<T> extends AbstractEntityQuery<T> implements IFieldValueOpt<T> {

	private HbatisStatementMapper<T> mapper;

	UpdateStatement<T> st;
	
	private DefaultFieldValueOpt<T> fieldOpt;
	public EntityUpdate(HbatisStatementMapper<T> mapper, EntityNode<T> n) {
		super(n);
		fieldOpt = new DefaultFieldValueOpt<>(n);
		this.mapper = mapper;
		this.st = StatementBuilder.buildUpdate(n);
	}
	public EntityUpdate<T> limit( int limit) {
		this.st.setLimit(limit);
		return this;
	}
	public int execute() {
		this.st.fields(fieldOpt.getFields());
		return this.mapper.updateByStatement(st);
	}

	public Restrictions<T> getRestrictions() {
		return st.restrictions();
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static <T> EntityUpdate<T> create(HbatisStatementMapper<T> repo, EntityNode<T> n) {
		return new EntityUpdate(repo, n);
	}
	public static <T> EntityUpdate<T> create(HbatisStatementMapper<T> repo, Class<T> clazz) {
		return create(repo,AbstractEntityNode.of(clazz));
	}


	@Override
	public IFieldValueOpt<T> setField(String field, Object val) {
		fieldOpt.setField(field, val);
		return fieldOpt;
	}


	@Override
	public <K> IFieldValueOpt<T> setField(FieldNode<T, K> fn, Object val) {
		fieldOpt.setField(fn, val);
		return fieldOpt;
	}


	@Override
	public IFieldValueOpt<T> setFieldNodeValue(String field, String field2) {
		fieldOpt.setFieldNodeValue(field, field2);
		return fieldOpt;
	}


	@Override
	public IFieldValueOpt<T> setFieldNodeValue(FieldNode<T,?> fn, FieldNode<T,?> val) {
		fieldOpt.setFieldNodeValue(fn, val);
		return fieldOpt;
	}


	@Override
	public IFieldValueOpt<T> setFieldExpression(String field, String expression) {
		fieldOpt.setFieldExpression(field, expression);
		return fieldOpt;
	}


	@Override
	public IFieldValueOpt<T> setFieldExpression(FieldNode<T, ?> fn, String expression) {
		fieldOpt.setFieldExpression(fn, expression);
		return fieldOpt;
	}


	@Override
	public IFieldValueOpt<T> setField(SFunction<? super T, ?> fieldFunc, Object value) {
		fieldOpt.setField(fieldFunc, value);
		return fieldOpt;
	}


	@Override
	public IFieldValueOpt<T> setFieldExpression(SFunction<? super T, ?> fieldFunc, String express) {
		fieldOpt.setField(fieldFunc, express);
		return fieldOpt;
	}


	@Override
	public IFieldValueOpt<T> setFieldNodeValue(SFunction<? super T, ?> fieldFunc,
			SFunction<? super T, ?> valueFunc) {
		fieldOpt.setField(fieldFunc, valueFunc);
		return fieldOpt;
	}


	@Override
	public IFieldValueOpt<T> removeField(FieldNode<T, ?> fieldNode) {
		fieldOpt.removeField(fieldNode);
		return fieldOpt;
	}


	@Override
	public List<FieldMetadata<T, ?>> getFields() {
		return fieldOpt.getFields();
	}
}
