package plus.ibatis.hbatis.orm.criteria.support;

import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.orm.criteria.Restrictions;
import plus.ibatis.hbatis.orm.criteria.statement.AggregationStatement;
import plus.ibatis.hbatis.orm.criteria.statement.InsertStatement;
import plus.ibatis.hbatis.orm.criteria.statement.SelectStatement;
import plus.ibatis.hbatis.orm.criteria.statement.UpdateStatement;

/**
 * StatementBuilder
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class StatementBuilder {

	private StatementBuilder() {

	}

	public static <E> SelectStatement<E> buildSelect(EntityNode<E> n) {
		return SelectStatement.newInstance(n);
	}
	public static <E> AggregationStatement<E> buildAggregation(EntityNode<E> n) {
		return AggregationStatement.newInstance(n);
	}
	public static <E> InsertStatement<E> buildInsert(EntityNode<E> n) {
		return InsertStatement.newInstance(n);
	}

	public static <E> UpdateStatement<E> buildUpdate(EntityNode<E> n) {
		return UpdateStatement.newInstance(n);
	}
	public static <E> Restrictions<E> buildRestrictions(EntityNode<E> entityNode){
		return Restrictions.newInstance(entityNode);
	}
}
