package plus.ibatis.hbatis.orm.criteria.support.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.util.Assert;

import plus.ibatis.hbatis.core.AbstractEntityNode;
import plus.ibatis.hbatis.core.Criterion;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;
import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.orm.criteria.Orders;
import plus.ibatis.hbatis.orm.criteria.SortOrder;

/**
 * query param
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public abstract class AbstractQueryParam<T> {

	public static final int LIMIT = 20;
	
	private Integer start = 0;

	private Integer limit = LIMIT;

	private Orders<T> orders;

	private List<Criterion<T,?>> conditions = new ArrayList<>();
	
	private FieldConditionProcessor conditionProcessor;
	
	//附加参数
	private Map<String,Object> param = new HashMap<>();
	
	//是否优化
	private boolean optimize = true;
	
	public Map<String, Object> getParam() {
		return param;
	}
	public void setParam(Map<String, Object> param) {
		this.param = param;
	}
	
	public void setPagination(int start,int limit) {
		this.start = start;
		this.limit = limit;
	}
	public Integer getStart() {
		return start;
	}
	public void setStart(Integer start) {
		this.start = start;
	}
	
	public Integer getLimit() {
		return this.limit;
	}

	public void setLimit(Integer limit) {
		this.limit = limit;
	}
	public AbstractQueryParam<T> nextPage() {
		Assert.notNull(this.getStart(),"Start of page params not setted");
		Assert.notNull(this.getLimit(),"Limit of page params not setted");
		Assert.isTrue(this.getLimit() > 0,"Limit of page params should greater then 0");
		this.start = this.start + this.limit;
		return this;
	}

	public void setOptimize(boolean optimize) {
		this.optimize = optimize;
	}
	public List<SortOrder> getSortOrders() {
		return orders().getOrderList();
	}
	public Orders<T> orders() {
		if(this.orders == null ) {
			this.orders = Orders.newInstance(this.entityNode);
		}
		return this.orders;
	}
	/**
	 * desc
	 * @param fn
	 * 			field node
	 * @return AbstractQueryParam
	 */
	public AbstractQueryParam<T> orderDesc(FieldNode<T,?> fn) {
		orders().desc(fn);
		return this;
	}
	/**
	 * asc
	 * @param fn field node
	 * @return AbstractQueryParam
	 */
	public AbstractQueryParam<T> orderAsc(FieldNode<T,?> fn) {
		orders().asc(fn);
		return this;
	}
	
	
	@SuppressWarnings("rawtypes")
	public List<Criterion<T,?>> getConditions() {
		if(!this.optimize) {
			return this.conditions;
		}
		conditions.sort((a,b)->{
			FieldMeta aMeta = a.getFieldNode().getFieldMeta();
			FieldMeta bMeta = b.getFieldNode().getFieldMeta();
			if(aMeta.isPrimaryKey()) {
				return -1;
			}
			int flag = aMeta.isIndexed()^bMeta.isIndexed()? (aMeta.isIndexed()?-1:1):0;
			return flag;
		});
		return conditions;
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void putConditions(Map map,EntityNode node) {
		FieldConditionMapping.process(map, this,conditionProcessor,node);
	}
	
	public void setConditionConversion(FieldConditionProcessor conditionConversion) {
		this.conditionProcessor = conditionConversion;
	}
	
	/**
	 * create condition
	 * @param node entity node
	 * @param fieldName field name
	 * @param value value
	 * @return Criterion
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	private Criterion createCondition(EntityNode node,String fieldName,Object value) {
		FieldNode fieldNode = node.getFieldNode(fieldName);
		return fieldNode.eq(value);
	}
	@SuppressWarnings({ "rawtypes"})
	public void addCondition(EntityNode node,String fieldName,Object value) {
		Criterion c = this.createCondition(node, fieldName, value);
		this.addCondition(c);
	}
	/**
	 * add condtion (not update if exists)
	 * @param fieldName field name
	 * @param value field value
	 */
	@SuppressWarnings("unchecked")
	public void addCondition(String fieldName,Object value) {
		Criterion<T,?> cnd = createCondition(this.entityNode,fieldName,value);
		this.conditions.add(cnd);
	}
	
	/**
	 * set condition (update if exists)
	 * @param node entity node
	 * @param fieldName field name
	 * @param value field value
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void putCondition(EntityNode node, String fieldName, Object value) {
		Criterion c = node.getFieldNode(fieldName).eq(value);
		putCondition(c);
	}
	/**
	 * set condition (update if exists)
	 * @param fieldName field name
	 * @param value field value
	 */
	public void putCondition(String fieldName,Object value) {
		this.putCondition(entityNode, fieldName, value);
	}
	/**
	 * remove conditions
	 * @param fieldNames field names
	 */
	@SuppressWarnings("rawtypes")
	public void removeConditions(String[] fieldNames) {
		Iterator<Criterion<T,?>> it = this.conditions.iterator();
		List<String> props = Arrays.asList(fieldNames);
		while(it.hasNext()) {
			Criterion tmp = it.next();
			String propName = tmp.getFieldNode().getPropertyName();
			if(tmp.getFieldNode().getEntityPath().equals(entityNode) && props.contains(propName)) {
				it.remove();
			}
		}
	}
	/**
	 * remove conditions
	 * @param node field nodes
	 */
	@SuppressWarnings("rawtypes")
	public void removeConditions(FieldNode ...node) {
		Iterator<Criterion<T,?>> it = this.conditions.iterator();
		List<FieldNode> nodes = Arrays.asList(node);
		while(it.hasNext()) {
			Criterion tmp = it.next();
			if(nodes.contains(tmp.getFieldNode())) {
				it.remove();
			}
		}
	}
	public void removeAllConditions() {
		conditions.clear();
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void putCondition(Criterion c) {
		Iterator<Criterion<T,?>> it = this.conditions.iterator();
		while(it.hasNext()) {
			Criterion tmp = it.next();
			if(tmp.getFieldNode().getSqlColumn().equals(c.getFieldNode().getSqlColumn()) && tmp.getOpKey().equals(c.getOpKey())) {
				it.remove();
			}
		}
		this.conditions.add(c);
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void addCondition(Criterion c) {
		this.conditions.add(c);
	}
	/**
	 * set order bys 
	 * @param str 
	 * 			such as: id desc,name asc
	 */
	public void setOrderBys(String str) {
		this.orders = Orders.fromString(this.entityNode, str);
	}
	public String getOrderBys() {
		return this.orders().toString();
	}
	@Deprecated
	public String getSortBys() {
		return this.orders().toString();
	}
	@Deprecated
	public void setSortBys(String str) {
		this.orders = Orders.fromString(this.entityNode, str);
	}
	public Set<String> getValueFields() {
		return this.conditions.stream().map(c->c.getFieldNode().getEntityPath().getEntityMeta().getEntityClass().getSimpleName()).collect(Collectors.toSet());
	}
	/**
	 * if contains field
	 * @param field field name
	 * @return if contains
	 */
	public boolean containsValueField(String field) {
		Set<String> valueFields = this.getValueFields();
		return valueFields.contains(field);
	}
	/**
	 * get field
	 * @param <V> Field Class
	 * @param field field name
	 * @return FieldNode
	 */
	public <V> FieldNode<T,V> field(String field) {
		return this.entityNode.getFieldNode(field);
	}
	private EntityNode<T> entityNode;
	
	public EntityNode<T> getEntityNode() {
		return entityNode;
	}
	public AbstractQueryParam(Class<T> clazz) {
		this.entityNode = AbstractEntityNode.of(clazz);
	}
	public AbstractQueryParam(plus.ibatis.hbatis.core.EntityNode<T> node) {
		this.entityNode = node;
	}
}
