package plus.ibatis.hbatis.orm.criteria.support.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import plus.ibatis.hbatis.core.Criterion;
import plus.ibatis.hbatis.core.CriterionOpts;
import plus.ibatis.hbatis.core.FieldNode;
/**
 * DefaultFieldConditionProcessor
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class DefaultFieldConditionProcessor implements FieldConditionProcessor{
	
	protected static DefaultFieldConditionProcessor INSTANCE = new DefaultFieldConditionProcessor();
	
	public static DefaultFieldConditionProcessor getInstance() {
		return INSTANCE;
	}
	@SuppressWarnings("rawtypes")
	@Override
	public <E> List<Criterion> process(FieldNode<E,?> fn,String prop, Object fieldValue) {
		if(fieldValue == null) {
			return processNullValue(fn,prop);
		}
		if(fieldValue instanceof String) {
			return processStringValue(fn,prop,fieldValue);
		} if(fieldValue instanceof Number) {
			return processNumberValue(fn,prop,fieldValue);
		} if(fieldValue instanceof Boolean) {
			return processBooleanValue(fn,prop,fieldValue);
		} if(fieldValue instanceof Date) {
			return processDateValue(fn,prop,fieldValue);
		} if(fieldValue instanceof Byte) {
			return processByteValue(fn,prop,fieldValue);
		} else if(fieldValue instanceof Map){
			return processMapValue(fn,prop,fieldValue);
		} else if(fieldValue instanceof Collection) {
			return processCollectionValue(fn,prop,fieldValue);
		} else {
			return processUnknownType(fn,prop,fieldValue);
		}
	}
	
	private List<Criterion> processNullValue(FieldNode fn, String prop) {
		Criterion cnd = fn.isNull();
		return Arrays.asList(cnd);
	}
	private <E> List<Criterion> processDateValue(FieldNode fn, String prop, Object fieldValue) {
		Criterion cnd = fn.eq(fieldValue);
		return Arrays.asList(cnd);
	}
	protected <E> List<Criterion> processStringValue(FieldNode fn, String prop, Object fieldValue) {
		Criterion cnd = fn.eq(fieldValue);
		return Arrays.asList(cnd);
	}
	protected <E> List<Criterion> processNumberValue(FieldNode fn, String prop, Object fieldValue) {
		Criterion cnd = fn.eq(fieldValue);
		return Arrays.asList(cnd);
	}
	protected <E> List<Criterion> processByteValue(FieldNode fn, String prop, Object fieldValue) {
		Criterion cnd = fn.eq(fieldValue);
		return Arrays.asList(cnd);
	}
	protected <E> List<Criterion> processBooleanValue(FieldNode fn, String prop, Object fieldValue) {
		Criterion cnd = fn.eq(fieldValue);
		return Arrays.asList(cnd);
	}
	protected <E> List<Criterion> processUnknownType(FieldNode<E, ?> fn, String prop, Object fieldValue) {
		return Collections.emptyList();
	}
	protected <E> List<Criterion> processCollectionValue(FieldNode fn, String prop, Object fieldValue) {
		Criterion cnd = fn.in((List)fieldValue);
		return Arrays.asList(cnd);
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	protected <E> List<Criterion>  processMapValue(FieldNode fn, String prop, Object fieldValue) {
		Map<String,Object> cnds = (Map)fieldValue;
		List<Criterion> rs = new ArrayList<>(cnds.size());
		for(Map.Entry<String,Object> entry:cnds.entrySet()) {
			String op = entry.getKey();
			Object value = entry.getValue();
			
			Criterion cItem = null;
			CriterionOpts opt = CriterionOpts.match(op.toLowerCase());
			if(opt == null) {
				throw new IllegalArgumentException("No operation named "+op);
			}
			if(value == null) { //如果值为空，支持is,nis
				if(CriterionOpts.IS.equals(opt) || CriterionOpts.NIS.equals(opt)) {
					cItem = new Criterion(fn,opt,value);
				} 
				continue;
			}
			
			if(!opt.isValueCollection()) {
				cItem = new Criterion(fn,opt,value);
			} else {
				List<Object> vals = (List)value;
				if(CriterionOpts.BETWEEN.getValue().equals(op) || CriterionOpts.NBETWEEN.getValue().equals(op)) {
					cItem = new Criterion(fn,opt,vals.get(0),vals.get(1));
				} else {
					cItem = new Criterion(fn,opt,value);
				}
			}
			if(cItem != null) {
				rs.add(cItem);
			}
		}
		return rs;
		
	}

}
