package plus.ibatis.hbatis.orm.criteria.support.query;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import plus.ibatis.hbatis.core.Criterion;
import plus.ibatis.hbatis.core.EntityNode;
import plus.ibatis.hbatis.core.FieldNode;

/**
 * map to conditions
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
class FieldConditionMapping {

	private static final Logger logger = LoggerFactory.getLogger(FieldConditionMapping.class);
	@SuppressWarnings({ "rawtypes" })
	public static void process(Map<String, Object> params, AbstractQueryParam r,FieldConditionProcessor processor) {
		process(params,r,processor,r.getEntityNode());
	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public static void process(Map<String, Object> params, AbstractQueryParam r,FieldConditionProcessor processor,EntityNode n) {
		if(params == null || params.isEmpty()) {
			return ;
		}
		List<FieldNode> fieldNodes = n.getFieldNodes();
		
		for(Map.Entry<String, Object> entry:params.entrySet()) {
			String prop = entry.getKey();
			Object value = entry.getValue();
			if(value == null || isEmpty(value)) { //如果值为空,不加入搜索条件
				continue;
			}
			FieldNode fn = fieldNodes.stream().filter(o -> o.getFieldMeta().getPropertyName().equals(prop)).findFirst().orElse(null);
			if(fn == null) { //skip
				logger.warn("Property not exists [property:{}],this condition will be skiped.",prop);
				continue;
			}
			if(processor == null) {
				processor = DefaultFieldConditionProcessor.getInstance();
			}
			List<Criterion> cnds = processor.process(fn,prop,value);
			if(cnds!=null) {
				for(Criterion c:cnds) {
					r.addCondition(c);
				}
			}
		}
		
	}
	
	

	@SuppressWarnings("rawtypes")
	private static boolean isEmpty(Object value) {
		if((value instanceof String)&& (value.toString().trim().length()<1)) {
			return true;
		} 
		if((value instanceof Collection)&& ((Collection)value).isEmpty()) {
			return true;
		} 
		if((value instanceof Map)&&((Map)value).isEmpty()) {
			return true;
		}
		return false;
	}
}
