package plus.ibatis.hbatis.orm.mapper;

import java.util.Collection;
import java.util.List;

/**
 * HbatisMapper
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public interface HbatisMapper<T,PK> extends HbatisStatementMapper<T> {
	
	
	/**
	 * insert
	 * @param entity
	 * 			entity object
	 * @return rows
	 */
	int insert(T entity);
	
	/**
	 * update
	 * @param entity
	 * 			entity object
	 * @return rows
	 */
	int update(T entity);
	/**
	 * select by primaryKey
	 * @param pk private key
	 * @return entity object
	 */
	T selectByPK(PK pk);
	/**
	 * select by primaryKeys
	 * @param pks primary keys
	 * @return entity objects
	 */
	List<T> selectByPKS(Collection<PK> pks);
	/**
	 * delete by primary key
	 * @param pk
	 * 			primary key
	 * @return rows
	 */
	int deleteByPK(PK pk);
	
	/**
	 * delete by primary keys
	 * @param pks
	 * 			primary keys
	 * @return rows
	 */
	int deleteByPKS(Collection<PK> pks);
	
	/**
	 * insert selective
	 * @param entity
	 * 			entity object
	 * @return rows
	 */
	int insertSelective(T entity);
	
	/**
	 * update selective
	 * @param entity
	 * 			entity object
	 * @return rows
	 */
	int updateSelective(T entity);
	
	/**
	 * count selective
	 * @param entity
	 * 			entity object
	 * @return rows
	 */
	long countSelective(T entity);
	
	/**
	 * select selective
	 * @param entity
	 * 			entity object
	 * @return List
	 */
	List<T> selectSelective(T entity);
   
	/**
	 * batch insert
	 * @param list
	 * 			entity objects
	 * @return rows
	 */
    int batchInsert(Collection<T> list);
    
    /**
     * select for update
     * @param pk primary key
     * @return entity
     */
    T selectForUpdate(PK pk);
}
