package plus.ibatis.hbatis.orm.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import plus.ibatis.hbatis.orm.annotation.EntityResultMapping;
import plus.ibatis.hbatis.orm.criteria.Restrictions;
import plus.ibatis.hbatis.orm.criteria.statement.AggregationStatement;
import plus.ibatis.hbatis.orm.criteria.statement.InsertStatement;
import plus.ibatis.hbatis.orm.criteria.statement.SelectStatement;
import plus.ibatis.hbatis.orm.criteria.statement.UpdateStatement;
/**
 * HbatisStatementMapper
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public interface HbatisStatementMapper<T> {

	/**
	 * insert by statement
	 * @param statement
	 * 			insert statement
	 * @return rows
	 */
	int insertByStatement(@Param("st")InsertStatement<T> statement);
	
	/**
	 * update by statement
	 * @param statement
	 * 			update statement
	 * @return rows
	 */
	int updateByStatement(@Param("st")UpdateStatement<T> statement);
	
	/**
	 * delete by restrictions
	 * @param restrictions
	 * 			conditions
	 * @return rows
	 */
	int deleteByRestrictions(@Param("restrictions")Restrictions<T> restrictions);
	
	/**
	 * select by statement
	 * @param statement
	 * 			select statement
	 * @return entity objects
	 */
	@EntityResultMapping
    List<T> selectByStatement(@Param("st") SelectStatement<T> statement);
    
	/**
	 * count by restrictions
	 * @param restrictions
	 * 			conditions
	 * @return count number
	 */
    long countByRestrictions(@Param("restrictions")Restrictions<T> restrictions);
    
    /**
     * aggregate by statement
     * @param st
     * 			aggregate statement
     * @return list maps
     */
	@SuppressWarnings("rawtypes")
	List<Map> aggregate(@Param("st")AggregationStatement<T> st);
	
}
