package plus.ibatis.hbatis.orm.sql;

import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;

import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;

/**
 * ResultMapsBuilder
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class ResultMapsBuilder {

	private ResultMapsBuilder() {
	}

	@SuppressWarnings("rawtypes")
	public static <E> List<ResultMapping> buildResultMappings(Configuration configuration, EntityClassDescriber<E> mapping) {
		List<EntityFieldDescriber> keyFields = mapping.getPrimaryKeys();
		List<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
		List<EntityFieldDescriber> fields = mapping.getFieldDescribers();
		for (EntityFieldDescriber fieldD : fields) {
			FieldMeta field = fieldD.getFieldMeta();
			String columnName = field.getColumnName();
			ResultMapping.Builder builder = new ResultMapping.Builder(configuration, field.getPropertyName(),
					columnName, field.getFieldType());
			resultMappings.add(builder.build());
			if (isPrimaryKey(keyFields, field.getPropertyName())) {

				List<ResultFlag> flags = new ArrayList<ResultFlag>();
				ResultFlag flag = org.apache.ibatis.mapping.ResultFlag.ID;
				flags.add(flag);
				builder.flags(flags);
			}
		}
		return resultMappings;
	}

	private static boolean isPrimaryKey(List<EntityFieldDescriber> keyFields, String property) {
		for (EntityFieldDescriber keyField : keyFields) {
			if (keyField.getField().getName().equals(property)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * buildResultMap
	 * @param <E> Entity class
	 * @param resultMapId
	 * 			resultmap id
	 * @param configuration
	 * 			ibatis configuration
	 * @param mapping
	 * 			entity class mapping
	 * @return ResultMap
	 */
	public static <E> ResultMap buildResultMap(String resultMapId, Configuration configuration, EntityClassDescriber<E> mapping) {

		Class<?> entityClass = mapping.getEntityMeta().getEntityClass();
		List<ResultMapping> resultMappings = buildResultMappings(configuration, mapping);

		ResultMap.Builder builder = new ResultMap.Builder(configuration, resultMapId, entityClass, resultMappings);

		ResultMap rm = builder.build();

		return rm;
	}
}
