package plus.ibatis.hbatis.orm.sql.builder;

import java.util.List;

import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;

import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.orm.sql.AbstractSqlBuilder;
import plus.ibatis.hbatis.orm.util.SqlBuilderHelper;

/**
 * CountSelectiveSqlBuilder
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class CountSelectiveSqlBuilder extends AbstractSqlBuilder {
	public CountSelectiveSqlBuilder(SqlSourceBuilder sqlSourceBuilder, Class<?> clazz) {
		super(sqlSourceBuilder, clazz);
	}

	public <E> String buildSql() {

		StringBuilder sb = new StringBuilder();
		sb.append("select count(1)");
		sb.append(" from `").append(this.getEntityMeta().getTableName()).append("`");
		List<FieldMeta<E, ?>> fields = this.getFieldMetas();

		sb.append("<trim prefix=\"where\" prefixOverrides=\"and\" suffixOverrides=\",\">");
		for (int i = 0; i < fields.size(); i++) {
			FieldMeta<E, ?> fm = fields.get(i);
			sb.append("<if test=\"").append(fm.getPropertyName()).append("!=null\">");
			sb.append(" and ");
			
			sb.append(fm.getColumnName()).append("=#{").append(fm.getPropertyName()).append(",jdbcType=")
					.append(fm.getJdbcType()).append("}");
			sb.append("</if>");
		}
		sb.append("</trim>");
		return sb.toString();
	}

	@Override
	public BoundSql getBoundSql(Object parameter) {
		Class<?> entityClass = this.getEntityMeta().getEntityClass();
		String sqlSourceId = entityClass.getName() + ":countSelective";
		SqlSource source = SqlBuilderHelper.getScriptSqlSource(sqlSourceId);
		if (source == null) {
			String script = this.buildSql();
			source = SqlBuilderHelper.buildScriptSqlSource(sqlSourceId, script, entityClass,
					this.sqlSourceBuilder.getConfiguration());
		}
		return source.getBoundSql(parameter);
	}

	@Override
	public SqlCommandType getSqlCommandType() {
		return SqlCommandType.SELECT;
	}

	@Override
	public Class<?> getResultType() {
		return Long.class;
	}
}
