package plus.ibatis.hbatis.orm.sql.builder;

import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlCommandType;

import plus.ibatis.hbatis.orm.sql.AbstractSqlBuilder;
import plus.ibatis.hbatis.orm.util.SqlBuilderHelper;

/**
 * DeleteByPKSSqlBuilder
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteByPKSSqlBuilder extends AbstractSqlBuilder {

	public DeleteByPKSSqlBuilder(SqlSourceBuilder sqlSourceBuilder, Class<?> clazz) {
		super(sqlSourceBuilder, clazz);
	}

	@Override
	public SqlCommandType getSqlCommandType() {
		return SqlCommandType.DELETE;
	}

	@Override
	public BoundSql getBoundSql(Object parameter) {

		String sqlSourceId = entityClass.getName() + ":deleteByPKS";
		return SqlBuilderHelper.getScriptSqlSourceIfAbsent(sqlSourceId, entityClass,
				this.sqlSourceBuilder.getConfiguration(), (cfg) -> {
					return sqlTpl;
				}).getBoundSql(parameter);

	}

	@Override
	public <E> String buildSql() {
		StringBuilder sb = new StringBuilder();
		sb.append("delete from `").append(this.getEntityMeta().getTableName()).append("`");
		sb.append(" where ");
		sb.append(SelectByPKSSqlBuilder.getPrimaryKeyInScript(this.getEntityDescriber()));
		return sb.toString();
	}

}
