package plus.ibatis.hbatis.orm.sql.builder;

import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlCommandType;

import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.orm.sql.AbstractSqlBuilder;
import plus.ibatis.hbatis.orm.util.SqlBuilderHelper;

/**
 * InsertSelectiveSqlBuilder
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class InsertSelectiveSqlBuilder extends AbstractSqlBuilder {
	public InsertSelectiveSqlBuilder(SqlSourceBuilder sqlSourceBuilder, Class<?> clazz) {
		super(sqlSourceBuilder, clazz);
	}

	public <E> String buildSql() {

		StringBuilder sb = new StringBuilder();
		String tableName = this.getEntityMeta().getTableName();
		sb.append("insert into ").append(tableName).append("(");

		List<FieldMeta<E, ?>> fields = this.getFieldMetas();

		List<FieldMeta<E, ?>> insertFields = new ArrayList<FieldMeta<E, ?>>();
		sb.append("<trim suffixOverrides=\",\">");
		for (FieldMeta<E, ?> fm : fields) {
			if (!fm.isInsertable()) {
				continue;
			}
			insertFields.add(fm);
			sb.append("<if test=\"").append(fm.getPropertyName()).append("!=null\">");
			sb.append("`").append(fm.getColumnName()).append("`,");
			sb.append("</if>");
			
		}
		sb.append("</trim>");
		sb.append(") values (");
		sb.append("<trim suffixOverrides=\",\">");
		for (int i = 0; i < insertFields.size(); i++) {
			FieldMeta<E, ?> fm = insertFields.get(i);
			sb.append("<if test=\"").append(fm.getPropertyName()).append("!=null\">");
			sb.append("#{").append(fm.getPropertyName()).append(",jdbcType=").append(fm.getJdbcType()).append("}").append(",");
			sb.append("</if>");
		}
		sb.append("</trim>");
		sb.append(")");
		return sb.toString();
	}

	@Override
	public BoundSql getBoundSql(Object parameter) {
		
		String sqlSourceId = entityClass.getName() + ":insertSelective";
		return SqlBuilderHelper
				.getScriptSqlSourceIfAbsent(sqlSourceId, entityClass, this.sqlSourceBuilder.getConfiguration(), (cfg) -> {
					return sqlTpl;
				}).getBoundSql(parameter);
	}

	@Override
	public SqlCommandType getSqlCommandType() {
		return SqlCommandType.INSERT;
	}

}
