package plus.ibatis.hbatis.orm.sql.builder;

import java.util.List;

import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.SqlCommandType;

import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.orm.sql.AbstractSqlBuilder;

/**
 * InsertSqlBuilder
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class InsertSqlBuilder extends AbstractSqlBuilder {

	public InsertSqlBuilder(SqlSourceBuilder sqlSourceBuilder, Class<?> clazz) {
		super(sqlSourceBuilder, clazz);
	}

	@Override
	public <E> String buildSql() {
		StringBuilder sb = new StringBuilder();

		String tableName = this.getEntityMeta().getTableName();
		sb.append("insert into `").append(tableName).append("`(");

		List<FieldMeta<E, ?>> fields = this.getFieldMetas();
		for (FieldMeta<E, ?> f : fields) {
			if(!f.isInsertable()) {
				continue;
			}
			sb.append("`").append(f.getColumnName()).append("`,");
		}
		sb = sb.deleteCharAt(sb.length() - 1);
		sb.append(") values (");
		for (FieldMeta<E, ?> f : fields) {
			if(!f.isInsertable()) {
				continue;
			}
			sb.append("#{").append(f.getPropertyName()).append(",jdbcType=").append(f.getJdbcType()).append("},");
		}
		sb = sb.deleteCharAt(sb.length() - 1).append(")");
		
		return sb.toString();
	}

	@Override
	public SqlCommandType getSqlCommandType() {
		return SqlCommandType.INSERT;
	}
	@Override
	public Class<?> getResultType() {
		return Integer.class;
	}
	
}
