package plus.ibatis.hbatis.orm.sql.builder;

import java.util.List;

import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlCommandType;

import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;
import plus.ibatis.hbatis.orm.sql.AbstractSqlBuilder;
import plus.ibatis.hbatis.orm.util.SqlBuilderHelper;

/**
 * SelectByPKSSqlBuilder
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class SelectByPKSSqlBuilder extends AbstractSqlBuilder {

	public SelectByPKSSqlBuilder(SqlSourceBuilder sqlSourceBuilder, Class<?> clazz) {
		super(sqlSourceBuilder, clazz);
	}

	@Override
	public SqlCommandType getSqlCommandType() {
		return SqlCommandType.SELECT;
	}

	public <E> String buildSql() {

		StringBuilder sb = new StringBuilder();
		sb.append("select ").append(this.getEntityDescriber().getTableBaseColumns());
		sb.append(" from `").append(this.getEntityDescriber().getEntityMeta().getTableName()).append("`");
		sb.append(" where ");
		sb.append(getPrimaryKeyInScript(this.getEntityDescriber()));
		return sb.toString();
	}

	@SuppressWarnings("rawtypes")
	protected static <E> String getPrimaryKeyInScript(EntityClassDescriber<E> tableMapping) {
		StringBuilder sb = new StringBuilder();
		List<EntityFieldDescriber> keyFields = tableMapping.getPrimaryKeys();
		if(keyFields.isEmpty()) {
			throw new RuntimeException("No key fields in "+tableMapping.getEntityMeta().getEntityClass());
		}
		if (keyFields.size() > 1) {
			sb.append("(");
			for (int i = 0; i < keyFields.size(); i++) {
				FieldMeta fm = keyFields.get(i).getFieldMeta();
				sb.append("`").append(fm.getColumnName()).append("`");
				if (i < keyFields.size() - 1) {
					sb.append(",");
				}
			}
			sb.append(")");
			sb.append(" in ");
			sb.append("<foreach collection=\"collection\" item=\"r\" index=\"keyIndex\" open=\"(\" close=\")\" separator=\",\">");
			for (int i = 0; i < keyFields.size(); i++) {
				FieldMeta fm = keyFields.get(i).getFieldMeta();

				sb.append("#{r.").append(fm.getPropertyName()).append("}");
				if (i < keyFields.size() - 1) {
					sb.append(",");
				}
			}
			sb.append("</foreach>");
			
		} else {
			FieldMeta km = keyFields.get(0).getFieldMeta();
			sb.append("`").append(km.getColumnName()).append("`");
			sb.append(" in ");
			sb.append("<foreach collection=\"collection\" item=\"id\" index=\"keyIndex\" open=\"(\" close=\")\" separator=\",\">");
			sb.append("#{id}");
			sb.append("</foreach>");
		}
		
		return sb.toString();
	}

	@Override
	public BoundSql getBoundSql(Object parameter) {

//		TextSqlNode node0 = new TextSqlNode("select "+mapping.getTableColumns()+" from `" + mapping.getTableName()+"`");
//		WhereSqlNode node1 = new WhereSqlNode(this.sqlSourceBuilder.getConfiguration(), SqlBuilderHelper
//				.buildSqlNodePrimaryKeysIn(mapping, entityClass, this.sqlSourceBuilder.getConfiguration()));
//
//		DynamicContext context = new DynamicContext(this.sqlSourceBuilder.getConfiguration(), parameter);
//
//		MixedSqlNode mixedSqlNode = new MixedSqlNode(Arrays.asList(node0, node1));
//		mixedSqlNode.apply(context);
//
//		DynamicSqlSource sqlSource = new DynamicSqlSource(this.sqlSourceBuilder.getConfiguration(), mixedSqlNode);
//
//		BoundSql boundSql = sqlSource.getBoundSql(parameter);
//
//		return boundSql;
		String sqlSourceId = entityClass.getName() + ":selectByPKS";
		return SqlBuilderHelper
				.getScriptSqlSourceIfAbsent(sqlSourceId, entityClass, this.sqlSourceBuilder.getConfiguration(), (cfg) -> {
					return sqlTpl;
				}).getBoundSql(parameter);

	}

	@Override
	public Class<?> getResultType() {
		return this.entityClass;
	}

}
