package plus.ibatis.hbatis.orm.sql.builder;

import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlCommandType;

import plus.ibatis.hbatis.orm.sql.AbstractSqlBuilder;
import plus.ibatis.hbatis.orm.util.SqlBuilderHelper;

public class SelectByPKSqlBuilder extends AbstractSqlBuilder {

	public SelectByPKSqlBuilder(SqlSourceBuilder sqlSourceBuilder, Class<?> clazz) {
		super(sqlSourceBuilder, clazz);
	}

	@Override
	public SqlCommandType getSqlCommandType() {
		return SqlCommandType.SELECT;
	}
	@Override
	public <E> String buildSql() {
		StringBuilder sb = new StringBuilder();
		sb.append("select ").append(this.getEntityDescriber().getTableBaseColumns());
		sb.append(" from `").append(this.getEntityMeta().getTableName()).append("`");
		sb.append(" where ").append(SqlBuilderHelper.buildPrimaryWhereSql(this.getEntityDescriber()));
		return sb.toString();
	}

	@Override
	public BoundSql getBoundSql(Object parameter) {
		if(parameter == null) {
			throw new IllegalArgumentException("Parameter must not be null");
		}
		return super.getBoundSql(parameter);
	}

	@Override
	public Class<?> getResultType() {
		return this.entityClass;
	}

}
