package plus.ibatis.hbatis.orm.sql.builder;

import java.util.List;

import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlCommandType;

import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.orm.sql.AbstractSqlBuilder;
import plus.ibatis.hbatis.orm.util.SqlBuilderHelper;

/**
 * SelectSelectiveSqlBuilder
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class SelectSelectiveSqlBuilder extends AbstractSqlBuilder {
	public SelectSelectiveSqlBuilder(SqlSourceBuilder sqlSourceBuilder, Class<?> clazz) {
		super(sqlSourceBuilder, clazz);
	}

	public <E> String buildSql() {

		StringBuilder sb = new StringBuilder();
		sb.append("select ").append(this.getEntityDescriber().getTableColumns());
		sb.append(" from `").append(this.getEntityMeta().getTableName()).append("`");
		List<FieldMeta<E, ?>> fields = this.getFieldMetas();

		sb.append("<trim prefix=\"where\" prefixOverrides=\"and\" suffixOverrides=\",\">");
		for (int i = 0; i < fields.size(); i++) {
			FieldMeta<E, ?> fm = fields.get(i);
			sb.append("<if test=\"").append(fm.getPropertyName()).append("!=null\">");
			sb.append(" and ");
			
			sb.append(fm.getColumnName()).append("=#{").append(fm.getPropertyName()).append(",jdbcType=")
					.append(fm.getJdbcType()).append("}");
			sb.append("</if>");
		}
		sb.append("</trim>");
		return sb.toString();
	}

	@Override
	public BoundSql getBoundSql(Object parameter) {
		String sqlSourceId = entityClass.getName() + ":selectSelective";
		return SqlBuilderHelper
				.getScriptSqlSourceIfAbsent(sqlSourceId, entityClass, this.sqlSourceBuilder.getConfiguration(), (cfg) -> {
					return sqlTpl;
				}).getBoundSql(parameter);
	}

	@Override
	public SqlCommandType getSqlCommandType() {
		return SqlCommandType.SELECT;
	}

	@Override
	public Class<?> getResultType() {
		return this.entityClass;
	}
}
