package plus.ibatis.hbatis.orm.sql.builder;

import java.util.ArrayList;
import java.util.List;

import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.SqlCommandType;

import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.orm.sql.AbstractSqlBuilder;
import plus.ibatis.hbatis.orm.util.SqlBuilderHelper;

/**
 * UpdateSelectiveSqlBuilder
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class UpdateSelectiveSqlBuilder extends AbstractSqlBuilder {
	public UpdateSelectiveSqlBuilder(SqlSourceBuilder sqlSourceBuilder, Class<?> clazz) {
		super(sqlSourceBuilder, clazz);
	}

	public <E> String buildSql() {
		
		StringBuilder sb = new StringBuilder();
		String tableName = this.entityDescriber.getEntityMeta().getTableName();
		sb.append("update ").append(tableName);

		List<FieldMeta<E, ?>> fields = this.getFieldMetas();

		List<FieldMeta<E, ?>> updateFields = new ArrayList<FieldMeta<E, ?>>();
		for (FieldMeta<E, ?> fm : fields) {
			if (!fm.isUpdatable()) {
				continue;
			}
			updateFields.add(fm);
		}
		sb.append("<trim prefix=\"set\" suffixOverrides=\",\">");
		for (int i = 0; i < updateFields.size(); i++) {
			FieldMeta<E, ?> fm = updateFields.get(i);
			sb.append("<if test=\"").append(fm.getPropertyName()).append("!=null\">");

			sb.append("`").append(fm.getColumnName()).append("`=#{").append(fm.getPropertyName()).append(",jdbcType=")
					.append(fm.getJdbcType()).append("}").append(",");
			sb.append("</if>");
		}
		sb.append("</trim>");
		// append where
		sb.append(" where ").append(SqlBuilderHelper.buildPrimaryWhereSql(this.getEntityDescriber()	));
		return sb.toString();
	}

	@Override
	public BoundSql getBoundSql(Object parameter) {
		
		String sqlSourceId = entityClass.getName() + ":updateSelective";
		return SqlBuilderHelper
				.getScriptSqlSourceIfAbsent(sqlSourceId, entityClass, this.sqlSourceBuilder.getConfiguration(), (cfg) -> {
					return sqlTpl;
				}).getBoundSql(parameter);
	}

	@Override
	public SqlCommandType getSqlCommandType() {
		return SqlCommandType.UPDATE;
	}

}
