package plus.ibatis.hbatis.orm.sql.builder;

import java.util.List;

import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.mapping.SqlCommandType;

import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.orm.sql.AbstractSqlBuilder;
import plus.ibatis.hbatis.orm.util.SqlBuilderHelper;

/**
 * UpdateSqlBuilder
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class UpdateSqlBuilder extends AbstractSqlBuilder {
	public UpdateSqlBuilder(SqlSourceBuilder sqlSourceBuilder, Class<?> clazz) {
		super(sqlSourceBuilder, clazz);
	}

	public <E> String buildSql() {
		
		StringBuilder sb = new StringBuilder();
		String tableName = this.getEntityMeta().getTableName();
		sb.append("update `").append(tableName).append("` set ");

		List<FieldMeta<E, ?>> fields = this.getFieldMetas();
		for (FieldMeta<E, ?> fm : fields) {
			if (!fm.isUpdatable()) {
				continue;
			}
			sb.append("`").append(fm.getColumnName()).append("`=#{").append(fm.getPropertyName()).append(",jdbcType=").append(fm.getJdbcType()).append("}").append(",");
		}

		sb = sb.deleteCharAt(sb.length() - 1);
		// append where
		sb.append(" where ").append(SqlBuilderHelper.buildPrimaryWhereSql(this.getEntityDescriber()));
		return sb.toString();
	}

	@Override
	public SqlCommandType getSqlCommandType() {
		return SqlCommandType.UPDATE;
	}

}
