package plus.ibatis.hbatis.orm.sql.builder.mysql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement.Builder;

import plus.ibatis.hbatis.core.IdStrategy;
import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;
import plus.ibatis.hbatis.core.util.EntityClassDescriberHelper;
import plus.ibatis.hbatis.keygen.ObjectIdKeyGenerator;
import plus.ibatis.hbatis.keygen.UuidKeyGenerator;
import plus.ibatis.hbatis.orm.sql.KeyGeneratorBuilder;

public class MysqlKeyGeneratorBuilder implements KeyGeneratorBuilder {

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public void build(Builder statement, Class<?> clazz) {
		EntityClassDescriber<?> entityDescriber = EntityClassDescriberHelper.getEntityClassDescriber(clazz);
		List<EntityFieldDescriber> fieldDescribers = entityDescriber.getFieldDescribers();
		int index = 0;
		for (EntityFieldDescriber fd : fieldDescribers) {
			if (index > 1)
				throw new RuntimeException("AutoIncrement column must be only one");
			IdStrategy strategy = fd.getFieldMeta().getIdStrategy();
			if (IdStrategy.IDENTITY.equals(strategy)) {
				statement.keyProperty(fd.getField().getName());
				statement.keyGenerator(new Jdbc3KeyGenerator());
				index++;
			} else if(IdStrategy.OBJECTID.equals(strategy)) {
				statement.keyProperty(fd.getField().getName());
				statement.keyGenerator(new ObjectIdKeyGenerator(fd.getFieldMeta()));
			} else if(IdStrategy.UUID.equals(strategy)) {
				statement.keyProperty(fd.getField().getName());
				statement.keyGenerator(new UuidKeyGenerator(fd.getFieldMeta()));
			} else if(IdStrategy.Custom.equals(strategy)) { //如果是自定义
				FieldMeta fm = fd.getFieldMeta();
				statement.keyProperty(fd.getField().getName());
				Class strategryClass = fm.getIdStrategyClass();
				if(!KeyGenerator.class.isAssignableFrom(strategryClass)) {
					throw new IllegalArgumentException("StrategryClass shoud be KeyGenerator"+strategryClass);
				}
				KeyGenerator keyGen = null;
				try {
					Constructor constructor=strategryClass.getDeclaredConstructor(plus.ibatis.hbatis.core.meta.FieldMeta.class);
					keyGen = (KeyGenerator) constructor.newInstance(fm);
				} catch (NoSuchMethodException | SecurityException |InstantiationException | IllegalAccessException |InvocationTargetException e) {
					throw new RuntimeException(e);
				}
				statement.keyGenerator(keyGen);
			}
		}
	}
}
