package plus.ibatis.hbatis.orm.util;

import java.lang.annotation.Annotation;
import java.util.List;

import plus.ibatis.hbatis.core.annotation.Column;
import plus.ibatis.hbatis.core.annotation.Id;
import plus.ibatis.hbatis.core.annotation.Table;
import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;
import plus.ibatis.hbatis.core.type.JdbcType;
import plus.ibatis.hbatis.core.util.EntityClassDescriberHelper;

public class EntityMysqlReverser {

	public static String readEntityClass(Class clazz) {
		Annotation table = clazz.getAnnotation(Table.class);
		if (table == null) {
			throw new RuntimeException("不可识别的实体对象:" + clazz);
		}
		EntityClassDescriber entityDescriber = EntityClassDescriberHelper.getEntityClassDescriber(clazz);

		StringBuilder sb = new StringBuilder();
		sb.append("create table ").append(entityDescriber.getEntityMeta().getTableName()).append("(\n");

		List<EntityFieldDescriber> fds = entityDescriber.getFieldDescribers();
		fds.sort((a,b)->{
			if(a.getFieldMeta().isPrimaryKey()&&!b.getFieldMeta().isPrimaryKey()) {
				return -1;
			}
			if(!a.getFieldMeta().isPrimaryKey()&&b.getFieldMeta().isPrimaryKey()) {
				return 1;
			}
			return 0;
		});
		for (int index = 0; index < fds.size(); index++) {
			EntityFieldDescriber fd = fds.get(index);
			FieldMeta fm = fd.getFieldMeta();
			sb.append("  `").append(fm.getColumnName()).append("` ");
			
			if(JdbcType.BOOLEAN.equals(fm.getJdbcType())) {
				sb.append("tinyint(1)");
			} else if(JdbcType.TIMESTAMP.equals(fm.getJdbcType())) {
				sb.append("timestamp(3)");
			} else if(JdbcType.DATE.equals(fm.getJdbcType())) {
				sb.append("datetime");
			}  else if(JdbcType.INTEGER.equals(fm.getJdbcType())) {
				sb.append("int(11)");
			} else if(JdbcType.DECIMAL.equals(fm.getJdbcType())) {
				sb.append("decimal(12,3)");
			} else {
				sb.append(fm.getJdbcType().name()).append("(");
				sb.append(fm.getLength()<0?32:fm.getLength());
				sb.append(")");
			}
			
			if (!fm.isPrimaryKey() && !fm.isNullable()) {
				sb.append(" not null ");
			}
			if (fm.isPrimaryKey()) {
				sb.append(" primary key");
			}
			if (fm.isAutoIncrement()) {
				sb.append(" autoincrement");
			}
			sb.append(" comment '").append(fm.getComment() == null ? "" : fm.getComment()).append("'");
			if (index < fds.size() - 1) {
				sb.append(",");
			}
			sb.append("\r\n");
		}
		sb.append(");");

		return sb.toString();
	}

	public static void main(String[] args) {
		String str = EntityMysqlReverser.readEntityClass(Demo.class);
		System.out.println(str);
	}

	@Table(name = "demo")
	public static class Demo {

		@Column(name = "id", length = 32, comment = "sddsfdsf")
		@Id
		private Integer id;

		@Column(name = "name", length = 32, comment = "sddsfdsf")
		private String name;
	}
}
