package plus.ibatis.hbatis.orm.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.xmltags.XMLScriptBuilder;
import org.apache.ibatis.session.Configuration;

import plus.ibatis.hbatis.core.meta.FieldMeta;
import plus.ibatis.hbatis.core.metaDescriber.EntityClassDescriber;
import plus.ibatis.hbatis.core.metaDescriber.EntityFieldDescriber;

public class SqlBuilderHelper {

	private static Map<String,SqlSource> sqlCache = new ConcurrentHashMap<String,SqlSource>();
	private SqlBuilderHelper() {
	}
	

	@SuppressWarnings("rawtypes")
	public static String buildPrimaryWhereSql(EntityClassDescriber<?> mapping) {
		StringBuilder sb = new StringBuilder();
		List<EntityFieldDescriber> keyFields = mapping.getPrimaryKeys();
		int keyIndex = 0;
		for (EntityFieldDescriber fd : keyFields) {
			if (keyIndex > 0) {
				sb.append(" and ");
			}
			String prop = fd.getField().getName();

			FieldMeta fm = fd.getFieldMeta();
			sb.append(fm.getColumnName()).append("=");
			sb.append("#{").append(prop).append(",jdbcType=").append(fm.getJdbcType()).append("}");
			keyIndex++;
		}
		return sb.toString();
	}

//	@Deprecated
//	@SuppressWarnings({ "rawtypes", "unchecked" })
//	public static SqlNode buildSqlNodePrimaryKeysIn(TableMapping mapping, Class<?> entityClass, Configuration cfg) {
//		String primaryKeyCnd = null;
//		TextSqlNode forEachItemNode = new TextSqlNode("#{r}");
//
//		List<EntityFieldDescriber> keyFields = EntityClassDescriberHelper.getPrimaryKeys(entityClass);
//		if (keyFields.size() == 1) {
//			EntityFieldDescriber keyField = keyFields.get(0);
//
//			String prop = keyField.getField().getName();
//			FieldMeta fm = (FieldMeta) TableMappingUtil.getFieldMeta(mapping, prop);
//			primaryKeyCnd = fm.getColumnName();
//
//		} else {
//			StringBuilder sb = new StringBuilder();
//			StringBuilder itemSb = new StringBuilder();
//			for (EntityFieldDescriber fd : keyFields) {
//				String prop = fd.getField().getName();
//				FieldMeta fm = fd.getFieldMeta();
//				sb.append(fm.getColumnName()).append(",");
//
//				itemSb.append("#{r.").append(prop).append("},");
//
//			}
//
//			primaryKeyCnd = "(" + sb.deleteCharAt(sb.length() - 1) + ")";
//
//			forEachItemNode = new TextSqlNode("(" + itemSb.deleteCharAt(itemSb.length() - 1) + ")");
//
//		}
//
//		ForEachSqlNode forEach = new ForEachSqlNode(cfg, forEachItemNode, "list", "index", "r", "(", ")", ",");
//
//		MixedSqlNode whereRootNode = new MixedSqlNode(Arrays.asList(new TextSqlNode(primaryKeyCnd + " in "), forEach));
//
//		return whereRootNode;
//
//	}
	
	public static SqlSource buildScriptSqlSource(String sqlSourceId,String sqlScript,Class<?> paramType,Configuration configuration) {
		SqlSource sqlSource = sqlCache.get(sqlSourceId);
		if(sqlSource != null) {
			return sqlSource;
		} 

		XNode xnode = XNodeUtil.getRootNode("<script>"+sqlScript+"</script>");
		XMLScriptBuilder scriptBuilder = new XMLScriptBuilder(configuration,xnode,paramType);
		sqlSource = scriptBuilder.parseScriptNode();
		
		sqlCache.put(sqlSourceId, sqlSource);
		return sqlSource;
		
	}
	public static SqlSource getScriptSqlSource(String sqlSourceId) {
		SqlSource sqlSource = sqlCache.get(sqlSourceId);
		return sqlSource;
		
	}
	public static SqlSource getScriptSqlSourceIfAbsent(String sqlSourceId,Class<?> paramType,Configuration cfg,Function<Configuration,String> fn) {
		SqlSource sqlSource = sqlCache.get(sqlSourceId);
		if(sqlSource != null) {
			return sqlSource;
		} 
		String sqlScript = fn.apply(cfg);
		XNode xnode = XNodeUtil.getRootNode("<script>"+sqlScript+"</script>");
		XMLScriptBuilder scriptBuilder = new XMLScriptBuilder(cfg,xnode,paramType);
		sqlSource = scriptBuilder.parseScriptNode();
		
		sqlCache.put(sqlSourceId, sqlSource);
		return sqlSource;
	}
}
