package plus.ibatis.hbatis.orm.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XNodeUtil {


	static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	private XNodeUtil() {
	}

	public static XNode getRootNode(String script) {
		InputStream is = null;
		try {
			is = new ByteArrayInputStream(script.getBytes());
			DocumentBuilder docBuilder;
			Document doc;
			Node node = null;
			try {
				docBuilder = factory.newDocumentBuilder();
				doc = docBuilder.parse(is);
				node = doc.getFirstChild(); 
			} catch (RuntimeException e) {
				throw e;
			} catch (Exception e) {
				throw new RuntimeException(e);
			}

			XPathParser xpathParser = new XPathParser(doc);

			XNode xnode = new XNode(xpathParser, node, new Properties());

			return xnode;
		} finally {
			try {
				if (is != null) {
					is.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
}
