package plus.ibatis.hbatis.plugins;

import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Invocation;

public class InnerInterceptorContext {
	private MappedStatement mappedStatement;
	private Invocation invocation;
	private Executor executor;
	private Object parameter;
	private BoundSql boundSql;
	
	/**
	 * 调用结果
	 */
	private Object invokedResult;
	
	private boolean sqlChanged = false;
	public InnerInterceptorContext(Invocation invocation) {
		this.invocation = invocation;
		Object target = invocation.getTarget();
	    Object[] args = invocation.getArgs();
	    if (target instanceof Executor) {
			executor =  (Executor) invocation.getTarget();
			mappedStatement = (MappedStatement)invocation.getArgs()[0];
			parameter = args[1];
			boundSql = mappedStatement.getBoundSql(parameter);
	    } else {
	    	StatementHandler handler = (StatementHandler) invocation.getTarget();
	    	this.boundSql = handler.getBoundSql();
	    	this.mappedStatement = Metas.statementHandler(handler).mappedStatement();
	    }
	}
	
	public boolean isSqlChanged() {
		return sqlChanged;
	}

	public void setSqlChanged(boolean sqlChanged) {
		this.sqlChanged = sqlChanged;
	}

	public Object getInvokedResult() {
		return invokedResult;
	}

	public void setInvokedResult(Object invokedResult) {
		this.invokedResult = invokedResult;
	}

	public SqlCommandType getSqlCommandType() {
		return this.mappedStatement.getSqlCommandType();
	}

	public MappedStatement getMappedStatement() {
		return mappedStatement;
	}
	public Invocation getInvocation() {
		return invocation;
	}
	public Executor getExecutor() {
		return executor;
	}
	public Object getParameter() {
		return parameter;
	}
	public BoundSql getBoundSql() {
		return boundSql;
	}
	
}
