package plus.ibatis.hbatis.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;

public class Metas {
	
	public static void setMappedStatementBoundSql(MappedStatement ms,String sql) {
        SystemMetaObject.forObject(ms).setValue("sqlSource.boundSql.sql", sql);
	}
	public static StatementHandlerMeta statementHandler(StatementHandler handler) {
		return new StatementHandlerMeta(handler);
	}
	public static BoundSqlMeta boundSql(BoundSql boundSql) {
		return new BoundSqlMeta(boundSql);
	}
	/**
     * {@link org.apache.ibatis.executor.statement.BaseStatementHandler}
     */
    public static class StatementHandlerMeta {
        private final MetaObject statementHandler;
        StatementHandlerMeta(StatementHandler handler) {
        	if(handler instanceof RoutingStatementHandler) {
				// 通过反射获取到当前RoutingStatementHandler对象的delegate属性
				RoutingStatementHandler rHandler = (RoutingStatementHandler)handler;
				Object delegateObj = SystemMetaObject.forObject(rHandler).getValue("delegate");
				this.statementHandler = SystemMetaObject.forObject(delegateObj);
			} else {
				this.statementHandler = SystemMetaObject.forObject(handler);
			}
        }

        public ParameterHandler parameterHandler() {
            return get("parameterHandler");
        }

        public MappedStatement mappedStatement() {
            return get("mappedStatement");
        }
        
        public Executor executor() {
            return get("executor");
        }

        public BoundSqlMeta boundSqlMeta() {
            return new BoundSqlMeta(boundSql());
        }
        
        public BoundSql boundSql() {
            return get("boundSql");
        }
        
        public Configuration configuration() {
            return get("configuration");
        }

        @SuppressWarnings("unchecked")
        private <T> T get(String property) {
            return (T) statementHandler.getValue(property);
        }
    }

    /**
     * {@link BoundSql}
     */
    public static class BoundSqlMeta {
        private final MetaObject boundSql;
        private final BoundSql delegate;

        BoundSqlMeta(BoundSql boundSql) {
            this.delegate = boundSql;
            this.boundSql = SystemMetaObject.forObject(boundSql);
        }

        public String sql() {
            return delegate.getSql();
        }

        public void sql(String sql) {
            boundSql.setValue("sql", sql);
        }

        public List<ParameterMapping> parameterMappings() {
            List<ParameterMapping> parameterMappings = delegate.getParameterMappings();
            return new ArrayList<>(parameterMappings);
        }

        public void parameterMappings(List<ParameterMapping> parameterMappings) {
            boundSql.setValue("parameterMappings", Collections.unmodifiableList(parameterMappings));
        }

        public Object parameterObject() {
            return get("parameterObject");
        }

        public Map<String, Object> additionalParameters() {
            return get("additionalParameters");
        }

        @SuppressWarnings("unchecked")
        private <T> T get(String property) {
            return (T) boundSql.getValue(property);
        }
    }
}
