package plus.ibatis.hbatis.plugins;

import java.util.HashMap;
import java.util.Map;

public class PluginContextHolder {

	private PluginContextHolder() {}
	
	static PluginContext ctx = new DefaultPluginContext();//默认
	public static void setContext(PluginContext ctx) {
		PluginContextHolder.ctx = ctx;
	}
	public static PluginContext getContext() {
		return ctx;
	}
	
	static class DefaultPluginContext implements PluginContext {
		private static ThreadLocal<Map<String, Object>> context = new InheritableThreadLocal<>();
		
		public static Map<String, Object> getContext(){
			Map<String, Object> value = context.get();
			if(value == null) {
				value = new HashMap<String,Object>();
				context.set(value);
			}
			return value;
		}
		public void setAttribute(String key,Object value) {
			getContext().put(key, value);
		}
		public Object getAttribute(String key) {
			return getContext().get(key);
		}
		@Override
		public void clear() {
			context.remove();
		}
		@Override
		public void removeAttribute(String key) {
			getContext().remove(key);
		}
	}
}
