package plus.ibatis.hbatis.plugins;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;


/**
 * PluginInterceptor
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
@Intercepts({
	@Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class}),
    @Signature(type = StatementHandler.class, method = "getBoundSql", args = {}),
		@Signature(type = Executor.class, method = "update", args = { MappedStatement.class, Object.class }), @Signature(type = Executor.class, method = "query", args = { MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class }), @Signature(type = Executor.class, method = "query", args = { MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class }) })
public class PluginInterceptor implements Interceptor {

	private List<InnerInterceptor> innerInterceptors = new ArrayList<>();

	public void addInnerInterceptor(InnerInterceptor interceptor) {
		innerInterceptors.add(interceptor);
	}

	@Override
	public Object intercept(Invocation invocation) throws Throwable {
		if (innerInterceptors.isEmpty()) {
			return invocation.proceed();
		}
		InnerInterceptorContext ctx = new InnerInterceptorContext(invocation);
		
		for (InnerInterceptor inner : innerInterceptors) {
			this.onInterceptor(inner,ctx);
			if(ctx.getInvokedResult() != null) { //如果有调用结果，就返回
				return ctx.getInvokedResult();
			}
		}
		
		return invocation.proceed();
	}

	private void onInterceptor(InnerInterceptor inner, InnerInterceptorContext ctx) throws InvocationTargetException, IllegalAccessException {
		Object target = ctx.getInvocation().getTarget();
		Object[] args = ctx.getInvocation().getArgs();
		if (target instanceof Executor) {
			if(SqlCommandType.SELECT.equals(ctx.getSqlCommandType())) {
				inner.beforeQuery(ctx);
			} else if(SqlCommandType.UPDATE.equals(ctx.getSqlCommandType())) {
				inner.beforeUpdate(ctx);
			}
		} else {
			// StatementHandler
			final StatementHandler sh = (StatementHandler) target;
			
			// 目前只有StatementHandler.getBoundSql方法args才为null
			if (null == args) {
				for (InnerInterceptor innerInterceptor : innerInterceptors) {
					innerInterceptor.beforeGetBoundSql(sh);
				}
			} else {
				Connection connections = (Connection) args[0];
				Integer transactionTimeout = (Integer) args[1];
				for (InnerInterceptor innerInterceptor : innerInterceptors) {
					innerInterceptor.beforePrepare(sh, connections, transactionTimeout,ctx);
				}
			}
		}
	}

	@Override
	public Object plugin(Object target) {
		if (target instanceof Executor || target instanceof StatementHandler) {
			return Plugin.wrap(target, this);
		} else {
			return target;
		}
	}

	@Override
	public void setProperties(Properties arg0) {

	}
}
