package plus.ibatis.hbatis.plugins.dataPermisson;

import java.util.List;
import java.util.Map;

import plus.ibatis.hbatis.plugins.PluginContext;
import plus.ibatis.hbatis.plugins.PluginContextHolder;

public class DataScopeContext{
	
	public static final String KEY_IGNORE = "dataScope.ignore";
	
	public static final String KEY_VALUES = "dataScope.values";
	
	public static IDataScopeProvider provider;
	
	private DataScopeContext() {
		
	}
	public static void setProvider(IDataScopeProvider provider) {
		DataScopeContext.provider = provider;
	}
	public static PluginContext getContext() {
		return PluginContextHolder.getContext();
	}
	public static boolean isIgnore() {
		Object val = getContext().getAttribute(KEY_IGNORE);
		if(val == null) {
			if(provider != null) {
				return provider.isIgnore();
			}
		}
		return Boolean.parseBoolean(val == null ? "false":val.toString());
	}
	public static void setIgnore(boolean flag) {
		getContext().setAttribute(KEY_IGNORE, flag);
	}
	public static void setDataScopes(Map<String,List<?>> scopes) {
		getContext().setAttribute(KEY_VALUES, scopes);
	}
	public static void clear() {
		getContext().clear();
	}
	/**
	 * 数据权限值
	 * key:权限关键字
	 * value:权限数据值（如范围，枚举值等)
	 * @return map
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public static Map<String,?> getDataScopes() {
		Object obj = getContext().getAttribute(KEY_VALUES);
		Map objMap =( obj == null?null:(Map)obj);
		if(objMap != null ) {
			return objMap;
		}
		if(provider != null) {
			return provider.getDataScopes();
		}
		return null;
	}
	
	public static interface IDataScopeProvider {
		Map<String,? extends Object> getDataScopes();
		
		boolean isIgnore();
	}
}
