package plus.ibatis.hbatis.plugins.dataPermisson;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;

/**
 * DataScopeDefine
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
@XmlAccessorType(XmlAccessType.FIELD)
public class DataScopeDefine {

	@XmlAttribute(name = "id")
	private String id;

	@XmlAttribute(name = "name")
	private String name;

	@XmlAttribute(name = "remark")
	private String remark;
	
	/**
	 * 关联全局定义(,分割，对非全局有效)
	 */
	@XmlAttribute(name = "withScopes")
	private String withScopes;
	
	@XmlElements(@XmlElement(name = "dataColumn"))
	private List<Definition> definitions;

	public Definition getDefinition(String key) {
		if (definitions == null || definitions.isEmpty()) {
			return null;
		}
		return definitions.stream().filter(d -> d.getKey().equals(key)).findFirst().orElse(null);
	}

	public void addDefinition(Definition def) {
		if (definitions == null || definitions.isEmpty()) {
			definitions = new ArrayList<>();
		}
		definitions.add(def);
	}

	public boolean isEmpty() {
		return definitions == null || definitions.isEmpty();
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public List<Definition> getDefinitions() {
		return definitions;
	}

	public void setDefinitions(List<Definition> definitions) {
		this.definitions = definitions;
	}

	public String getWithScopes() {
		return withScopes;
	}

	public void setWithScopes(String withScopes) {
		this.withScopes = withScopes;
	}

	@Override
	public String toString() {
		return new StringBuilder().append("DataScopeDefine[id:").append(this.getId())
				.append(",name:").append(this.getName()).append(",definitions:").append(this.getDefinitions()).append("]").toString();
	}

	@XmlAccessorType(XmlAccessType.FIELD)
	public static class Definition {

		@XmlAttribute(name = "key", required = true)
		private String key;

		@XmlAttribute(name = "columnAlias", required = false)
		private String columnAlias;

		@XmlAttribute(name = "column", required = true)
		private String column;

		@XmlAttribute(name = "dataType", required = false)
		private Class<?> dataType;

		public String getKey() {
			return key;
		}

		public void setKey(String key) {
			this.key = key;
		}

		public String getColumnAlias() {
			return columnAlias;
		}

		public void setColumnAlias(String columnAlias) {
			this.columnAlias = columnAlias;
		}

		public String getColumn() {
			return column;
		}

		public void setColumn(String column) {
			this.column = column;
		}

		public Class<?> getDataType() {
			return dataType;
		}

		public void setDataType(Class<?> dataType) {
			this.dataType = dataType;
		}

		@Override
		public String toString() {
			StringBuilder sb = new StringBuilder();
			return sb.append("Definition[").append("key:").append(this.getKey()).append(",columnAlias:").append(this.getColumnAlias()).append(",dataType:").append(this.getDataType()).append("]").toString();
		}

	}

}
