package plus.ibatis.hbatis.plugins.dataPermisson;


import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import plus.ibatis.hbatis.plugins.InnerInterceptor;
import plus.ibatis.hbatis.plugins.InnerInterceptorContext;
import plus.ibatis.hbatis.plugins.Metas;
import plus.ibatis.hbatis.plugins.PluginUtils;

/**
 * DataScopeInnerInterceptor
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class DataScopeInnerInterceptor implements InnerInterceptor {
	
	private DataScopeSqlProcessor dataScopeSqlProcessor;
	public DataScopeInnerInterceptor() {
		this.dataScopeSqlProcessor = new DefaultDataScopeSqlProcessor();
	}
	public DataScopeInnerInterceptor(DataScopeSqlProcessor processor) {
		this.dataScopeSqlProcessor = processor;
	}
	public boolean accept(SqlCommandType cmdType) {
		return SqlCommandType.SELECT.equals(cmdType) &&!DataScopeContext.isIgnore();
	}
	@Override
	public void beforeQuery(InnerInterceptorContext ctx) throws InvocationTargetException, IllegalAccessException {
		if(!accept(ctx.getSqlCommandType())) {
			return ;
		}
		MappedStatement ms = ctx.getMappedStatement();
		DataScopeDefine define = DataScopeStatementHolder.getDataScopeDefine(ms);
		if(define == null || define.isEmpty()) {
			return ;
		}
		BoundSql boundSql = ctx.getBoundSql();
		Metas.BoundSqlMeta sqlMeta = Metas.boundSql(boundSql);
		String sql = sqlMeta.sql();
		Statement st;
		try {
			st = CCJSqlParserUtil.parse(sql);
		} catch (JSQLParserException e) {
			throw new RuntimeException(e);
		}
		if(st instanceof Select) {
			try {
				parseSelect((Select)st,define,ctx);
			} catch (JSQLParserException e) {
				throw new RuntimeException("datascope sql parse errr",e);
			}
		}
		if(ctx.isSqlChanged()) {
			String rewriteSql = st.toString();
			ctx.getInvocation().getArgs()[0] = PluginUtils.newMappedStatement(ms, boundSql, rewriteSql);
		}
	}
	private void parseSelect(Select select,DataScopeDefine scopeDefine,InnerInterceptorContext ctx) throws JSQLParserException {
		SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            this.setWhere(selectBody,scopeDefine, ctx);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList) selectBody;
            List<SelectBody> selectBodyList = setOperationList.getSelects();
            for(SelectBody sb:selectBodyList) {
            	this.setWhere(sb,scopeDefine,ctx);
            }
        }
	}
	private void setWhere(SelectBody selectBody, DataScopeDefine scopeDefine,InnerInterceptorContext ctx) throws JSQLParserException {
		dataScopeSqlProcessor.process(selectBody,scopeDefine,ctx);
	}
}
