package plus.ibatis.hbatis.plugins.dataPermisson;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

import org.apache.ibatis.mapping.MappedStatement;

import plus.ibatis.hbatis.plugins.dataPermisson.annotations.DataColumn;
import plus.ibatis.hbatis.plugins.dataPermisson.annotations.DataScope;
import plus.ibatis.hbatis.plugins.dataPermisson.annotations.DataScopeIgnore;

class DataScopeStatementHolder {

	private static Set<String> statementReadFlag = new HashSet<>();
	
	private DataScopeStatementHolder() {}
	
	/**
	 * get datascope define
	 * @param ms mapped statement
	 * @return DataScopeDefine
	 */
	public static DataScopeDefine getDataScopeDefine(MappedStatement ms) {
		String statementId = ms.getId();
		DataScopeDefine define = DataScopeStatementRegistry.getDefine(statementId);
		if(define != null) {
			return define;
		}
		if(statementReadFlag.contains(statementId)){
			return define;
		}
		DataScope ds;
		try {
			ds = readDataScope(ms);
		} catch (ClassNotFoundException e) {
			throw new RuntimeException(e);
		}
		statementReadFlag.add(statementId);
		if(ds == null) {
			return null;
		}
		
		DataScopeDefine dsDef = new DataScopeDefine();
		dsDef.setId(statementId);
		
		//全局
		String[] globalCodes = ds.withScopes();
		if(globalCodes != null && globalCodes.length>0) {
			dsDef.setWithScopes(String.join(",",globalCodes));
		}
		//自定义
		for(DataColumn dc:ds.values()) {
			DataScopeDefine.Definition def = new DataScopeDefine.Definition();
			def.setKey(dc.key());
			def.setColumnAlias(dc.alias());
			def.setColumn(dc.column());
			def.setDataType(dc.dataType());
			dsDef.addDefinition(def);
		}
		DataScopeStatementRegistry.regist(statementId, dsDef);
		return dsDef;
	}

	@SuppressWarnings("rawtypes")
	private static DataScope readDataScope(MappedStatement ms) throws ClassNotFoundException {
		String statementId = ms.getId();
		String className = statementId.substring(0,statementId.lastIndexOf("."));
		String methodName = statementId.substring(statementId.lastIndexOf(".")+1);
		Class cla = Class.forName(className);
		Method[] methods = cla.getMethods();
		for(Method m :methods) {
			if(m.getName().equals(methodName)) {
				if(m.isAnnotationPresent(DataScopeIgnore.class)) {
					DataScopeIgnore dsIgnore = m.getAnnotation(DataScopeIgnore.class);
					if(dsIgnore.value()) {
						return null;
					}
				}
				return m.getAnnotation(DataScope.class);
			}
		}
		return null;
	}
}
