package plus.ibatis.hbatis.plugins.dataPermisson;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import plus.ibatis.hbatis.plugins.PluginUtils;

/**
 * DataScopeStatementRegistry
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class DataScopeStatementRegistry {

	private static final Logger log = LoggerFactory.getLogger(DataScopeStatementRegistry.class);
	private DataScopeStatementRegistry() {}
	
	private static Map<String,DataScopeDefine> statementDataScope = new ConcurrentHashMap<>();
	private static Map<String,DataScopeDefine> globalDataScope = new ConcurrentHashMap<>();
	
	static {
		registFromClassPath("/META-INF/dataScope.xml");
	}
	public static boolean containsDefine(String statementId) {
		return statementDataScope.containsKey(statementId);
	}
	public static DataScopeDefine getDefine(String statementId) {
		return statementDataScope.get(statementId);
	}
	
	/**
	 * regist define
	 * @param statementId
	 * 			statement id
	 * @param define
	 * 			datascope define
	 */
	public static void regist(String statementId,DataScopeDefine define) {
		if(define.getWithScopes() != null) {
			String[] scopes = define.getWithScopes().split(",");
			for(String scope:scopes) {
				DataScopeDefine gs = getGlobal(scope);
				mergeGlobalDefine(gs,define);
			}

		}
		log.info("Regist datascope :{}",define);
		statementDataScope.put(statementId, define);
	}
	private static DataScopeDefine mergeGlobalDefine(DataScopeDefine globalDef, DataScopeDefine define) {
		if(globalDef == null || globalDef.isEmpty()) {
			return define;
		}
		for(DataScopeDefine.Definition gd:globalDef.getDefinitions()) {
			DataScopeDefine.Definition d =define.getDefinition(gd.getKey());
			if(d == null) {
				define.addDefinition(gd);
			}
		}
		return define;
	}
	public static void registGlobal(String code,DataScopeDefine define) {
		log.info("Regist global datascope :{}",define);
		globalDataScope.put(code, define);
	}
	public static DataScopeDefine getGlobal(String code) {
		return globalDataScope.get(code);
	}
	/**
	 * regist from classpath
	 * @param xmlClassPath
	 * 			xml classpath
	 */
	public static void registFromClassPath(String xmlClassPath) {
		log.debug("Regist datascope defines by path:{}",xmlClassPath);
		InputStream in = DataScopeStatementRegistry.class.getClassLoader().getClass().getResourceAsStream(xmlClassPath);
		if(in == null) {
			log.info("DataScope resource not exists!");
			return ;
		}
		DefinitionDoc doc = null;
		try {
			doc = PluginUtils.readXml(in, DefinitionDoc.class);
		} catch (JAXBException e) {
			throw new RuntimeException("Read datascope definition error",e);
		}
		//全局
		List<DataScopeDefine> gsDefines = (doc.getGlobalScopes() == null?null:doc.getGlobalScopes().getScopeDefines());
		if(gsDefines != null) {
			for(DataScopeDefine r:gsDefines) {
				registGlobal(r.getId(), r);
			}
		}
		//自定义
		List<DataScopeDefine> sts = (doc.getScopeStatements() == null?null:doc.getScopeStatements().getScopeDefines());
		if(sts != null) {
			for(DataScopeDefine r:sts) {
				regist(r.getId(), r);
			}
		}
		
	}
	
	@XmlRootElement(name="root")
	@XmlAccessorType(XmlAccessType.FIELD)
	static class DefinitionDoc {
		
		@XmlElement(name = "global")
		private ScopeStatements globalScopes;
		
		@XmlElement(name = "statements")
		private ScopeStatements scopeStatements;
		public ScopeStatements getScopeStatements() {
			return scopeStatements;
		}
		public ScopeStatements getGlobalScopes() {
			return globalScopes;
		}
		public void setGlobalScopes(ScopeStatements globalScopes) {
			this.globalScopes = globalScopes;
		}
		
	}
	
	@XmlAccessorType(XmlAccessType.FIELD)
	static class ScopeStatements {
		@XmlElements(@XmlElement(name="statement"))
		private List<DataScopeDefine> scopeDefines;

		public List<DataScopeDefine> getScopeDefines() {
			return scopeDefines;
		}

		public void setScopeDefines(List<DataScopeDefine> scopeDefines) {
			this.scopeDefines = scopeDefines;
		}
	}
}
