package plus.ibatis.hbatis.plugins.dataPermisson;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SubSelect;
import plus.ibatis.hbatis.plugins.InnerInterceptorContext;
import plus.ibatis.hbatis.plugins.dataPermisson.DataScopeDefine.Definition;

/**
 * DefaultDataScopeSqlProcessor 
 * @author zz
 * @version 1.0.0
 * @since 1.0.0
 */
public class DefaultDataScopeSqlProcessor implements DataScopeSqlProcessor {

	private static final Logger logger = LoggerFactory.getLogger(DefaultDataScopeSqlProcessor.class);
	@Override
	public void process(SelectBody selectBody,DataScopeDefine scopeDefine, InnerInterceptorContext ctx) throws JSQLParserException {
		List<String> segs = this.processSelectBody(selectBody, scopeDefine);
		if(segs != null && segs.size()>0) {
			ctx.setSqlChanged(true);
			segs.clear();
			segs = null;
		}
	}
	
	/**
	 * 处理查询体
	 * @param selectBody
	 * 			select body
	 * @param scopeDefine
	 * 			datascope define
	 * @return rows
	 * @throws JSQLParserException
	 * 			 parser exception
	 */
	public List<String> processSelectBody(SelectBody selectBody,DataScopeDefine scopeDefine) throws JSQLParserException {
		if (!(selectBody instanceof PlainSelect)) {
			return null;
		}
		List<String> allSegs = new ArrayList<>();
		PlainSelect plainSelect = (PlainSelect) selectBody;
		FromItem fromItem = plainSelect.getFromItem();
		List<Join> joins = plainSelect.getJoins();
		boolean isProceedTable = false;
		if (fromItem instanceof SubSelect) {
			SubSelect subSelect = (SubSelect) fromItem;
			List<String> tmp = processSelectBody(subSelect.getSelectBody(), scopeDefine);
			if(tmp != null) {
				allSegs.addAll(tmp);
			}
		} else if (fromItem instanceof Table) {
			List<String> tmp =  setWhere(plainSelect,(Table)fromItem,scopeDefine);
			if(tmp != null) {
				isProceedTable = true;
				allSegs.addAll(tmp);
			}
		}
		if(joins != null) {
			for(Join join:joins) {
				FromItem rightFromItem = join.getRightItem();
				if (rightFromItem instanceof SubSelect) { //如果右表为子查询，处理
					SubSelect subSelect = (SubSelect) rightFromItem;
					List<String> tmp = processSelectBody(subSelect.getSelectBody(), scopeDefine);
					if(tmp != null) {
						allSegs.addAll(tmp);
					}
				} else if (rightFromItem instanceof Table) {
					if(!isProceedTable) { //避免二次处理
						List<String> tmp =  setWhere(plainSelect,(Table)rightFromItem,scopeDefine);
						if(tmp != null) {
							allSegs.addAll(tmp);
						}
					}
				}
			}
		}
		return allSegs;
		
	}
	private List<String> setWhere(PlainSelect plainSelect,Table table,DataScopeDefine scopeDefine) throws JSQLParserException {
		List<String> sqlSegs = this.createExpressions(table,scopeDefine);
		if (sqlSegs == null || sqlSegs.isEmpty()) {
			return null;
		}
		Expression where = plainSelect.getWhere();
		if (where == null) {
			plainSelect.setWhere(CCJSqlParserUtil.parseCondExpression(sqlSegs.get(0)));
		} else {
			plainSelect.setWhere(new AndExpression(where, CCJSqlParserUtil.parseCondExpression(sqlSegs.get(0))));
		}
		for (int i = 1; i < sqlSegs.size(); i++) {
			plainSelect.setWhere(new AndExpression(where, CCJSqlParserUtil.parseCondExpression(sqlSegs.get(i))));
		}
		return sqlSegs;
	}
	/**
	 * default expression build
	 * @param table
	 * 			talbe
	 * @param scopeDefine
	 * 			datascope define
	 * @return List
	 */
	@SuppressWarnings("unchecked")
	protected List<String> createExpressions(Table table, DataScopeDefine scopeDefine) {
//		Table table = (Table) select.getFromItem();
		
		List<String> sqlSegs = new ArrayList<>();
		Map<String,?> profiles = DataScopeContext.getDataScopes();

		if (profiles != null && !profiles.isEmpty()) {
			for (Map.Entry<String,?> entry : profiles.entrySet()) {

				String key = entry.getKey();
				List<String> vals = entry.getValue() == null?null:(List<String>)entry.getValue();
				DataScopeDefine.Definition dc = scopeDefine.getDefinition(key);
				if (dc == null || vals == null || vals.size()<1) {
					continue;
				}
				boolean isDataScopeColumn = isDataScopeColumn(table,dc);
				if(isDataScopeColumn) {
					String colName = isEmpty(dc.getColumnAlias()) ? "`"+dc.getColumn()+"`" : "`"+dc.getColumnAlias() + "`.`" + dc.getColumn()+"`";
					if (vals.size() == 1) {
						sqlSegs.add(colName + "=" + processValue(vals.get(0), dc));
					} else {
						sqlSegs.add(colName + " in " + processValues(vals, dc));
					}
				} else {
					//
					if(logger.isDebugEnabled()) {
						logger.debug("Column [{}] not in sql[{}],will igornal data scope filter.",dc.getColumnAlias()+"."+dc.getColumn(),table);
					}
				}
			}
		}
		return sqlSegs;
	}
	private boolean isEmpty(String str) {
		return str == null || str.trim().length()<1;
	}
	protected boolean isDataScopeColumn(Table table, Definition dc) {
		if(dc.getColumnAlias() == null || dc.getColumnAlias().length()<1) {
			return true;
		}
		String tableAlias = table.getAlias() == null?null:table.getAlias().getName(); //表别名
		return dc.getColumnAlias().equals(tableAlias)||dc.getColumnAlias().equals(tableAlias.replaceAll("`", ""));
	}

	protected String processValue(String val, DataScopeDefine.Definition dc) {
		if (dc.getDataType()!=null && dc.getDataType().isAssignableFrom(Number.class)) {
			return val;
		} else {
			return "'" + val + "'";
		}
	}

	protected String processValues(List<String> vals,DataScopeDefine.Definition dc) {
		StringBuilder sb = new StringBuilder("(");
		for (int i = 0; i < vals.size(); i++) {
			String val = vals.get(i);
			sb.append(this.processValue(val, dc));
			if (i < vals.size() - 1) {
				sb.append(",");
			}
		}
		sb.append(")");
		return sb.toString();
	}
}
